package com.pangding.web.tright.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.InitDao;

import java.io.Serializable;
import java.util.Date;

@TableAnnotation("pd_user")
public class UserVo implements Serializable, InitDao {

    @TableAnnotation("tu_id")
    private Long tuId;//主键ID
    @TableAnnotation("user_name")
    private String userName;//用户名
    private String password;//密码
    @TableAnnotation("phone_number")
    private String phoneNumber;//手机号
    @TableAnnotation("create_time")
    private String createTime;//创建时间
    @TableAnnotation("login_time")
    private String loginTime;//登录时间
    @TableAnnotation("last_login_time")
    private String lastLoginTime;//上次登录时间
    private Integer count;//登录次数

    public Long getTuId() {
        return tuId;
    }

    public void setTuId(Long tuId) {
        this.tuId = tuId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(String loginTime) {
        this.loginTime = loginTime;
    }

    public String getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public void init() {
        this.createTime = StringHelper.getFirst(this.createTime, DateHelper.getNow());
        this.loginTime = StringHelper.getFirst(this.loginTime, DateHelper.getNow());
        this.lastLoginTime = StringHelper.getFirst(this.lastLoginTime, DateHelper.getNow());
    }
}
