package com.pangding.web.authority.service;


import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.CompanyVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.CompanyResVo;
import com.pangding.web.authority.vo.resvo.DetailResVo;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author Administrator
 */
public interface CompanyService{

    /**
     * 修改公司信息
     * @param companyVo
     */
    void updateCompanyStatus(CompanyVo companyVo);

    /**
     * 分页查询公司信息
     * @param reqVo 继承了分页对象
     * @return 公司列表分页对象
     */
    PageSizeData<CompanyVo> list(ListCompanyReqVo reqVo);

    /**
     * 胖丁查询用户，公司和公司扩展表信息以及银行卡列表
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司，公司扩展表和银行卡列表信息的对象
     */
    CompanyResVo pdGetDetail(CompanyGetReqVo reqVo);

    List<CompanyVo> productOrInterface(ProductOrInterfaceReqVo reqVo);

    /**
     * 商户查看详情，根据公司id返回用户信息和公司主表信息
     * @param reqVo 包含公司id的请求对象
     * @return 封装了用户，公司主表信息的对象
     */
    DetailResVo getDetail(CompanyGetReqVo reqVo);

    /**
     * 新增/修改公司信息
     * @param reqVo 公司以及公司扩展表信息
     * @return 公司id
     */
    CompanyVo saveCompany(CompanyAndCompanyExtendSaveReqVo reqVo);

    void deleteCompany(DeleteCompanyReqVo reqVo);

    /**
     * 保存银行卡信息，并调用第三方接口发送手机验证码
     *
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    String saveBank(CompanyBankCardVo reqVo);

    void deleteBank(CompanyBankCardVo reqVo);

   /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    CompanyBankCardVo bankSubmit(BankSubmitReqVo reqVo);

    void setDefault(CompanyBankCardVo reqVo);

    /**
     * 获取我的二维码url
     * @param reqVo 公司扩展表请求对象
     * @return 公司二维码url
     */
    String getQrCodeUrl(CompanyExtendGetReqVo reqVo);

    /**
     * 根据二维码源码调用微信接口获取二维码url
     * @param reqVo 封装了公司id，页面选项的请求对象
     * @return 二维码url，目前没有调用微信接口，仅返回null
     */
    String createQrCodeUrl(CreateQrCodeUrlReqVo reqVo);

    /**
     * 获取银行卡列表
     * @param reqVo 继承了分页对象，含公司id
     * @return 银行卡列表分页对象
     */
    PageSizeData<CompanyBankCardVo> getBankCardList(BankCardListReqVo reqVo);

    /**
     * 添加用户
     * @param reqVo 封装了用户信息和用户角色信息的请求对象
     * @return 用户id
     */
    String saveUser(WebUserReqVo reqVo);
}
