package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.reqvo.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/27 11:18
 */
public interface IndexService {
    /**
     * 通过公司id获取该公司的可提现余额
     * @param reqVo 封装了公司id的请求对象
     * @return 可提现的金额
     */
    BigDecimal getWithdrawCash(WithdrawCashReqVo reqVo);

    /**
     * 通过公司id获取该公司累积总收益
     * @param reqVo 封装了公司id的请求对象
     * @return 累计总收益
     */
    BigDecimal getTotalIncome(TotalIncomeReqVo reqVo);

    /**
     * 通过公司id获取该公司的用户沉淀量
     * @param reqVo 封装了公司id的请求对象
     * @return  用户沉淀量
     */
    Integer getUserPrecipitation(UserPrecipitationReqVo reqVo);

    /**
     * 通过公司id获取该公司今日实收金额
     * @param reqVo 封装了公司id的请求对象
     * @return  今日实收金额
     */
    BigDecimal getTodayIncome(TodayIncomeReqVo reqVo);

    /**
     * 通过公司id获取该公司的跨界盈利
     * @param reqVo 封装了公司id的请求对象
     * @return  跨界盈利
     */
    String getTransboundaryProfit(TransboundaryProfitReqVo reqVo);

    List<Long> getUserTrending(UserTrendingReqVo reqVo);

    Object getFundTrending(FundTrendingReqVo reqVo);
}
