package com.pangding.web.authority.service;

import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListRoleReqVo;
import com.pangding.web.authority.vo.reqvo.WebRoleReqVo;
import com.pangding.web.authority.vo.RoleVo;
import com.pangding.web.authority.vo.resvo.WebRoleResVo;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleService {

    /**
     * 保存RoleVo对象,并保存角色权限的对应关系
     *
     * @param webRoleReqVo
     * @return 返回角色id
     */
    String saveRole(WebRoleReqVo webRoleReqVo);

    /**
     * 更新RoleVo对象,并更新角色权限的对应关系
     *
     * @param webRoleReqVo RoleDto对象
     * @return 返回角色id
     */
    String updateRole(WebRoleReqVo webRoleReqVo);

    /**
     * 通过主键id查询RoleVo对象
     *
     * @param webRoleReqVo 主键
     * @return RoleVo对象
     */
    WebRoleResVo getRoleById(WebRoleReqVo webRoleReqVo);

    /**
     * 检查角色名是否已存在
     *
     * @param roleVo RoleVo对象
     */
    void checkNameExist(RoleVo roleVo);

    /**
     * 获取RoleVo对象列表
     *
     * @param req
     * @return RoleVo对象列表分页对象
     */
    PageSizeData<RoleVo> getRoleVoList(ListRoleReqVo req);

    /**
     * 获取角色返回信息分页对象
     *
     * @param req
     * @return 角色返回信息分页对象
     */
    PageSizeData<WebRoleResVo> getWebRoleResVoList(ListRoleReqVo req);

    /**
     * 通过角色id查询该角色权限id列表
     *
     * @param roleId 角色id
     * @return 权限id列表
     */
    List<AuthorityVo> getAuthorityListByRoleId(String roleId);

    /**
     * 通过权限id查询权限名
     *
     * @param authorityId 权限id
     * @return 权限名
     */
    String getAuthorityNameByAuthorityId(String authorityId);

    /**
     * 将RoleVo对象添加权限ID列表和权限名列表封装成RoleDto对象
     *
     * @param roleVo RoleVo对象
     * @param authorityList 权限列表
     * @return RoleDto对象
     */
    WebRoleResVo makeResVo(RoleVo roleVo, List<AuthorityVo> authorityList);

    /**
     * 删除角色，并删除角色和用户的对应关系以及角色和权限的对应关系
     *
     * @param roleVo RoleVo对象
     */
    void deleteRole(RoleVo roleVo);

    /**
     * 删除角色信息
     *
     * @param webRoleReqVo
     */
    void delete(WebRoleReqVo webRoleReqVo);

}
