package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.RoleDao;
import com.pangding.web.authority.dao.UserDao;
import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.resvo.WebUserResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangjinyao
 */
@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;

    @Autowired
    UserRoleDao userRoleDao;

    @Autowired
    RoleDao roleDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveUser(WebUserReqVo webUserReqVo) {
        this.isValid(webUserReqVo.getAccount());
        this.checkAccount(webUserReqVo);
        this.checkPhone(webUserReqVo);
        webUserReqVo.setRemark(webUserReqVo.getPassword());
        String md5Password = this.passwordEncoder(webUserReqVo.getPassword());
        webUserReqVo.setPassword(md5Password);
        webUserReqVo.setId(StringHelper.getNewID());

        UserVo userVo = new UserVo();
        ObjectHelper.writeWithFrom(userVo,webUserReqVo);
        userDao.create(userVo);
        saveUserRole(webUserReqVo);

        return userVo.getId();
    }

    private void saveUserRole(WebUserReqVo webUserReqVo){
        if (webUserReqVo.getRoleIds()!=null && !webUserReqVo.getRoleIds().isEmpty()){
            List<String> roleIds = webUserReqVo.getRoleIds();
            for (String roleId : roleIds) {
                UserRoleVo userRoleRelation = new UserRoleVo();
                userRoleRelation.setRoleId(roleId);
                userRoleRelation.setUserId(webUserReqVo.getId());
                userRoleRelation.setId(StringHelper.getNewID());
                userRoleDao.create(userRoleRelation);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String updateUser(WebUserReqVo webUserReqVo) {
        this.isValid(webUserReqVo.getAccount());
        this.checkAccount(webUserReqVo);
        this.checkPhone(webUserReqVo);
        webUserReqVo.setRemark(webUserReqVo.getPassword());
        webUserReqVo.setPassword(this.passwordEncoder(webUserReqVo.getPassword()));

        UserVo userVo = webUserReqVo;
        userDao.update(userVo);
        UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
        reqVo.setUserId(webUserReqVo.getId());
        List<UserRoleVo> userRoleList = userRoleDao.getUserRoleList(reqVo);
        if(userRoleList != null && !userRoleList.isEmpty()){
            List<String> userRoleIdList = new ArrayList(userRoleList.size());
            for (UserRoleVo userRole:userRoleList) {
                userRoleIdList.add(userRole.getId());
            }
            if (userRoleIdList != null && !userRoleIdList.isEmpty()){
                for (String userRoleId:userRoleIdList){
                    UserRoleRemoveReqVo userRole = new UserRoleRemoveReqVo();
                    userRole.setId(userRoleId);
                    userRoleDao.remove(userRole);
                }
            }
        }
        saveUserRole(webUserReqVo);

        return userVo.getId();
    }

    @Override
    public void checkAccount(UserVo userVo) {
        userDao.checkAccount(userVo);
    }

    @Override
    public void checkPhone(UserVo userVo) {
        userDao.checkPhone(userVo);
    }

    @Override
    public String passwordEncoder(String password) { return StringHelper.md5(password); }


    @Override
    public WebUserResVo makeResVo(UserVo userVo) {

        WebUserResVo resVo = new WebUserResVo();
        ObjectHelper.writeWithFrom(resVo,userVo);

        UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
        reqVo.setUserId(userVo.getId());
        List<UserRoleVo> userRoleVoList = this.listUserRoleListByUserId(reqVo);
        if (userRoleVoList != null && !userRoleVoList.isEmpty()){
            List<RoleVo> roleList = new ArrayList(userRoleVoList.size());
            for (UserRoleVo userRoleRelation:userRoleVoList) {
                String roleId = userRoleRelation.getRoleId();
                RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
                roleGetReqVo.setId(roleId);
                RoleVo roleVo = roleDao.load(roleGetReqVo,RoleVo.class);
                roleList.add(roleVo);
            }
            resVo.setRoleList(roleList);
        }

        return resVo;
    }

    @Override
    public WebUserResVo getUserById(String userId) {
        UserGetReqVo reqVo = new UserGetReqVo();
        reqVo.setId(userId);
        UserVo userVo = userDao.getUser(reqVo);
        if (userVo == null){
            throw new CodeException("该用户不存在");
        }
        WebUserResVo resVo = this.makeResVo(userVo);
        return resVo;
    }

    @Override
    public List<UserRoleVo> listUserRoleListByUserId(UserRoleGetReqVo reqVo) {
        return userRoleDao.getUserRoleList(reqVo);
    }

    @Override
    public RoleVo getRoleByRoleId(RoleGetReqVo roleGetReqVo) {
        return roleDao.getRoleById(roleGetReqVo);
    }

    @Override
    public Boolean isNumeric(String account) {
        for (int i = 0;i < account.length();i++){
            if (!Character.isDigit(account.charAt(i))){
                return false;
            }
        }

        return true;
    }

    @Override
    public void isValid(String account) {
        String regex = "^(?!\\d+$)[\\da-zA-Z]+$";
        if(!account.matches(regex)){
            throw new CodeException("用户名仅支持字母和数字的组合，且不能为纯数字");
        }
    }

    @Override
    public UserVo getUserByPhone(String phone) {
        UserGetReqVo reqVo = new UserGetReqVo();
        reqVo.setPhone(phone);
        return userDao.load(reqVo,UserVo.class);
    }

    @Override
    public UserVo getUserByAccount(String account) {
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setAccount(account);
        return userDao.load(userGetReqVo, UserVo.class);
    }

    @Override
    public PageSizeData<UserVo> getUserVoList(ListUserReqVo reqVo) {
        PageSizeData<UserVo> userVoPageSizeData = userDao.getUserVoList(reqVo);
        if (userVoPageSizeData.getList() == null || userVoPageSizeData.getList().isEmpty()){
            throw new CodeException("没有更多用户");
        }
        return userVoPageSizeData;
    }

    @Override
    public PageSizeData<WebUserResVo> getWebUserResVoList(ListUserReqVo reqVo) {
        PageSizeData<UserVo> userVoPageSizeData = this.getUserVoList(reqVo);
        PageSizeData<WebUserResVo> webUserResVoPageSizeData = new PageSizeData();
        List<UserVo> userVoList = userVoPageSizeData.getList();
        List<WebUserResVo> webUserResVoList = new ArrayList(userVoList.size());
        for (UserVo userVo:userVoList) {
            WebUserResVo resVo = new WebUserResVo();
            List<RoleVo> roleVoList = this.getRoleListByUserId(userVo.getId());

            ObjectHelper.writeWithFrom(resVo,userVo);

            webUserResVoList.add(resVo);
        }
        webUserResVoPageSizeData.setPageTotal(webUserResVoPageSizeData.getPageTotal());
        webUserResVoPageSizeData.setList(webUserResVoList);
        webUserResVoPageSizeData.setPageIndex(webUserResVoPageSizeData.getPageIndex());
        webUserResVoPageSizeData.setPageSize(webUserResVoPageSizeData.getPageSize());

        return webUserResVoPageSizeData;
    }

    @Override
    public List<RoleVo> getRoleListByUserId(String userId) {
        UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
        reqVo.setUserId(userId);
        List<UserRoleVo> userRoleVoList = userRoleDao.getUserRoleList(reqVo);
        if (userRoleVoList != null && !userRoleVoList.isEmpty()){
            List<RoleVo> roleVoList = new ArrayList(userRoleVoList.size());
            for (UserRoleVo userRoleVo:userRoleVoList) {
                RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
                roleGetReqVo.setId(userRoleVo.getRoleId());
                RoleVo roleVo = roleDao.load(roleGetReqVo,RoleVo.class);
                roleVoList.add(roleVo);
            }
            return roleVoList;
        }
        return null;
    }
}
