package com.pangding.web.authority.vo;

import com.yanzuoguang.dao.TableAnnotation;
import com.yanzuoguang.util.vo.BaseVo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author zhangjinyao
 * @create 2019/5/16 15:35
 */
@TableAnnotation("pd_company_extend")
public class CompanyExtendVo extends BaseVo {
    private String id;

    @TableAnnotation("QR_code")
    private String qrCode;

    @TableAnnotation("QR_code_type")
    private String qrCodeType;

    @TableAnnotation("QR_code_url")
    private String qrCodeUrl;

    /**
     * 是否分账
     */
    @TableAnnotation("subledger_status")
    private String subledgerStatus;

    /**
     * 分账规则
     */
    @TableAnnotation("subledger_rule_id")
    private String subledgerRuleId;

    /**
     * 是否分润
     */
    @TableAnnotation("divide_status")
    private String divedeStatus;

    /**
     * 分润规则
     */
    @TableAnnotation("divide_rule_id")
    private String divideRuleId;

    /**
     * 是够可提现
     */
    @TableAnnotation("withdraw_status")
    private String withdrawStatus;

    /**
     * 提现规则
     */
    @TableAnnotation("withdraw_rule_id")
    private String withdrawRuleId;

    /**
     * 可提现总额
     */
    @TableAnnotation("withdraw_total_cash")
    private BigDecimal withdrawTotalCash;

    /**
     * 是否扫码支付
     */
    @TableAnnotation("scan_code_pay_status")
    private String scanCodePayStatus;

    /**
     * 支付规则
     */
    @TableAnnotation("pay_rule_id")
    private String payRuleId;

    /**
     * 是否邀请
     */
    @TableAnnotation("invitation_status")
    private String invitationStatus;

    /**
     * 邀请规则
     */
    @TableAnnotation("invitation_rule_id")
    private String invitateRuleId;

    @TableAnnotation("invitation_code")
    private String invitationCode;

    public BigDecimal getWithdrawTotalCash() {
        return withdrawTotalCash;
    }

    public void setWithdrawTotalCash(BigDecimal withdrawTotalCash) {
        this.withdrawTotalCash = withdrawTotalCash;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public String getQrCodeType() {
        return qrCodeType;
    }

    public void setQrCodeType(String qrCodeType) {
        this.qrCodeType = qrCodeType;
    }

    public String getQrCodeUrl() {
        return qrCodeUrl;
    }

    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
    }

    public String getSubledgerStatus() {
        return subledgerStatus;
    }

    public void setSubledgerStatus(String subledgerStatus) {
        this.subledgerStatus = subledgerStatus;
    }

    public String getSubledgerRuleId() {
        return subledgerRuleId;
    }

    public void setSubledgerRuleId(String subledgerRuleId) {
        this.subledgerRuleId = subledgerRuleId;
    }

    public String getDivedeStatus() {
        return divedeStatus;
    }

    public void setDivedeStatus(String divedeStatus) {
        this.divedeStatus = divedeStatus;
    }

    public String getDivideRuleId() {
        return divideRuleId;
    }

    public void setDivideRuleId(String divideRuleId) {
        this.divideRuleId = divideRuleId;
    }

    public String getWithdrawStatus() {
        return withdrawStatus;
    }

    public void setWithdrawStatus(String withdrawStatus) {
        this.withdrawStatus = withdrawStatus;
    }

    public String getWithdrawRuleId() {
        return withdrawRuleId;
    }

    public void setWithdrawRuleId(String withdrawRuleId) {
        this.withdrawRuleId = withdrawRuleId;
    }

    public String getScanCodePayStatus() {
        return scanCodePayStatus;
    }

    public void setScanCodePayStatus(String scanCodePayStatus) {
        this.scanCodePayStatus = scanCodePayStatus;
    }

    public String getPayRuleId() {
        return payRuleId;
    }

    public void setPayRuleId(String payRuleId) {
        this.payRuleId = payRuleId;
    }

    public String getInvitationStatus() {
        return invitationStatus;
    }

    public void setInvitationStatus(String invitationStatus) {
        this.invitationStatus = invitationStatus;
    }

    public String getInvitateRuleId() {
        return invitateRuleId;
    }

    public void setInvitateRuleId(String invitateRuleId) {
        this.invitateRuleId = invitateRuleId;
    }

    public String getInvitationCode() {
        return invitationCode;
    }

    public void setInvitationCode(String invitationCode) {
        this.invitationCode = invitationCode;
    }
}
