# 参数请符合实体，而不是单独的参数,专注于参数内容，专注于参数顺序
``` java 
{
  id: "1"
}
```
如:
```java 
public List<String> getRoleTrightPKListByRoleId(String roleId) {
    return this.query(String.class,GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,roleId);
}
```


# RoleDaoImpl
## 夏敏的函数请用load，可以删除
``` java 
@Override
public RoleVo getRoleById(String id) {
    return this.queryFirst(RoleVo.class,GET_ROLE_BY_ID,id);
}

@Override
public RoleVo getRoleByName(String name) {
    return this.queryFirst(RoleVo.class,GET_ROLE_BY_NAME,name);
}
```
参见如下代码:
``` java 
dao.load({id:"1"})
dao.load({name:"1"})
```

## 检测语句
``` java 
table.add(CHECK_NAME_EXIST,"select count(r.id) from pd_role r where 1=1 ")
.add("name","and r.name = ? ")
.add("id","and r.id <> ?");
```
改成
```java 
table.addExist(CHECK_NAME_EXIST,"name");
```
调用时
``` java 
this.checkExist(CHECK_NAME_EXIST,roleVo,"橘色名称已经存在");
```

# 请确定语句主表，比如说和 pd_role_authority表和pd_authority表的查询，请另外新建dao层，符合三层架构规范
``` java 

table.add(GET_TRIGHTID_LIST,"select authority_id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");

table.add(GET_TRIGHTNAME_BY_TRIGHTID,"select name from pd_authority where 1=1 ")
.add("trightId","and id = ?");

```

# ＳＱＬ语句合并
```java 
table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");

table.add(GET_ROLE_TRIGHT_PKLIST_BY_TRIGHTID,"select id from pd_role_authority where 1=1 ")
.add("trightId","and tright_id = ?");
```
可以合并为
```java 

table.add(GET_ROLE_TRIGHT_PKLIST_BY_ROLEID,"select id from pd_role_authority where 1=1 ")
.add("roleId","and role_id = ?");
.add("trightId","and tright_id = ?");
```

# 更爱ＳＱＬ语句
```java 
 table.add(CHECK_VALID,"select count(a.id) from pd_authority a where 1=1 ")
        .add("name","and a.name = ? ")
        .add("url","and a.url = ? ")
        .add("id","and a.id <> ?");
```
改为:
``` java 
table.addExist(CHECK_VALID,"name","url");
```

# 将如下ＳＱＬ语句合并
``` java
table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
.add("id","and id = ?");

table.add(LIST_ALL,"select * from pd_authority where 1=1");

table.add(LIST_LEVEL_ONE,"select * from pd_authority where pid=null");
// 这句ＳＱＬ语句可以去掉，本身没有意义
table.add(CHECK_CHILD,"select count(id) from pd_authority where 1=1 ")
.add("id","and pid = ?");

table.add(GET_CHILDID_LIST,"select id from pd_authority where 1=1 ")
.add("id","and pid = ?");
```
如:
is null, is not null , ifnull(field,'')=''
```java 
table.add(GET_TRIGHT_BY_ID,"select * from pd_authority where 1=1 ")
.add("id","and id = ?")
.add("top","and ifnull(pid,'')= ''")
.add("pid","and pid = ?");
```

# 将如下ＳＱＬ语句合并
``` java
table.add(GET_USER, "SELECT  id,account,phone,status,remark,create_time,creator FROM pd_user  WHERE 1=1 ")
        .add("account", " AND account = ?");

table.add(GET_ALL_USERS,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1");

table.add(GET_ROLE_IDS,"select role_id from pd_user_role where 1=1 ")
        .add("userId","and user_id = ?");

table.add(GET_USER_BY_ID,"select id,account,phone,status,remark,create_time,creator from pd_user where 1=1 ")
        .add("userId","and user_id = ?");

table.add(GET_ROLE_BY_ROLEID,"select name from pd_role where 1=1 ")
        .add("roleId","and id = ?");
```

# 如下语句可以删除
``` java
table.add(DELETE_USER_ROLE,"delete from pd_user_role_relation where 1=1 ")
        .add("userId","and user_id = ?");
```
直接调用:
``` 
dao.remove({userId:"1"})
```


# ------------2019-5-19--------------
# 实体中不能引用继承自Date的对象，会存在时区问题 Timestamp,用String配合DateHelper类进行处理

# md5函数已经编写，需要去掉Md5AndSalt类
StringHelper.md5(from)


# 如下代码需要调换顺序
```java 
List<RoleVo> roleVoList = roleServiceImpl.getRoleVoList();
List<RoleDto> webRoleReqVoList = new ArrayList(roleVoList.size());     // roleVoList有可能为null
if (roleVoList == null || roleVoList.size() == 0){
    return new Result(0,"暂无角色信息",null);
}
```

# cloudvo请放到vo中，定义一个cloud的文件夹

# controller命名空间改成web命名空间,controller太长了，并且拦截器拦截的 web....Controller

# currency中的Result实体，需要以vo结尾，并且放入vo，并且自解释太弱，需要把名称补全，如OrderResultVo

# Dto这个命名空间不存在,需要命名的是放在 vo里面，增加res或者req文件夹.并且以 ResVo或者ReqVo结尾，表明是请求信息。
如: 
OrderLoadReqVo,订单加载请求实体
OrderLoadResVo，订单加载输出实体

# GetUserByIdReqVo、GetRoleReqVo等几个实体可以合成为一个
如： UserGetReqVo，该实体具有多个字段
RoleGetReqVo
RoleGetResVo
如果：觉得构造函数复杂，写几个 public static RoleGetReqVo createByRoleId(String roleId);

数据库实体命名规范为: {表名}Vo
实体命名规范为: {表名}{动作}{请求|输出}Vo

# AuthorityController层不能返回Object，请返回ResponseResult
除非你做的是第三方接口
ResponseResult.result()

# Controller层只能检测参数，不能写任何逻辑，逻辑层是Service


# Controller没有参数的函数，不能存在
companyId

#---------------2019-5-20---------------------------
# 建议将所有的`@RequestMapping(method=RequestMethod.POST)`改成`@PostMapping()`，代码会少点。
如:
``` java 
@RequestMapping(value = "/role", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
```
改成:
``` java 
@PostMapping(value = "/role", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
```

# 建议将 list.size() == 0 改成 list.isEmpty()

# @RequestBody的时候不需要去判断整个对象是否为空，因为不可能为空，会出现404错误
``` java 
public ResponseResult saveIndividual(@RequestBody RegisterIndividualReqVo reqVo){
    CheckerHelper.newInstance()
            .notBlankCheck("reqVo",reqVo)  // 这行代码可以去掉
```

# 功能还未完成
``` java 
LoginResVo resVo = new LoginResVo();
resVo.setUserVo(userVo);
resVo.setCompanyVo(companyVo);
resVo.setCompanyBankCardVo(companyBankCardVo);
resVo.setCompanyExtendVo(companyExtendVo);
```



# 如下函数请启用事物
``` java
@Override
@Transactional(rollbackFor = Exception.class) // 这里增加
public void delete(WebRoleReqVo webRoleReqVo) {
    RoleVo roleVo = this.getRoleById(webRoleReqVo);
    this.deleteRole(roleVo);
}
```

# 建议改成StringHelper.compare(),因为有可能某一个值为null
``` java
if (!registerUserReqVo.getPassword().equals(registerUserReqVo.getConfirmPassword())){
    throw new CodeException("确认密码错误");
}
改成
if (!StringHelper.compare( registerUserReqVo.getPassword(), registerUserReqVo.getConfirmPassword()){
    throw new CodeException("确认密码错误");
}
```


# 整体代码注释太少
请问AuthorityServiceImpl类的作用时干啥的？ 
各个函数是干啥的？
各个函数的各个语句时干啥的？ 
合适的代码，注释要占用20%以上,通常４０％。

# 建议将 UserServiceImpl.saveUser 和 UserServiceImpl.updateUser改成一个函数来处处理
1. 设置主表编号,主表记录为空则创建，否则更新
2. 删除历史用户角色关联
UserRoleGetReqVo reqVo = new UserRoleGetReqVo();
reqVo.setUserId(webUserReqVo.getId());
userRoleDao.remove(reqVo);
3. 创建用户角色关联


# 建议将 saveEnterprise 和 saveIndividual 函数代码合并，因为保存的内容有部分一致
# 字段名称相同时，可以采用 ObjectHelper.writeWithFrom(companyVo,reqVo); 需要注意，别用后台生成值覆盖了前台传输值
``` java
companyVo.setId(reqVo.getId());
companyVo.setMerchantId(reqVo.getMerchantId());
companyVo.setCompanyType(reqVo.getCompanyType());
companyVo.setCompanyName(reqVo.getCompanyName());
companyVo.setAddress(reqVo.getCompanyAddress());
companyVo.setBusinessLicenseCode(reqVo.getBusinessLicenseCode());
companyVo.setCompanyAttribute(reqVo.getCompanyAttribute());
companyVo.setContactName(reqVo.getContactName());
companyVo.setContactCode(reqVo.getContactCode());
companyVo.setContactPhone(reqVo.getContactPhone());
```

# 有可能拥有此用户，而没有拥有公司，需要抛出异常
``` java
companyReqVo.setId(userVo.getCompanyId());
CompanyVo companyVo = companyDaoImpl.load(companyReqVo,CompanyVo.class);
```

# 函数内实体尽量在引用之前创建，而不是一起创建，代码可读性更好
``` java 

CompanyVo companyReqVo = new CompanyVo();
CompanyBankCardVo companyBankCardReqVo = new CompanyBankCardVo();
CompanyExtendVo companyExtendReqVo = new CompanyExtendVo();

companyReqVo.setId(userVo.getCompanyId());
CompanyVo companyVo = companyDaoImpl.load(companyReqVo,CompanyVo.class);
companyBankCardReqVo.setCompanyId(userVo.getCompanyId());
CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(companyBankCardReqVo,CompanyBankCardVo.class);
companyExtendReqVo.setId(userVo.getCompanyId());
CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendReqVo,CompanyExtendVo.class);

```

``` java 

// 这里是否需要检测公司编号为空，否则有可能导致全表索引
if(StringHelper.isEmpty(userVo.getCompanyId())){
    throw new CodeException("该员工公司编号不存在");
}

// 加载公司
CompanyVo companyReqVo = new CompanyVo();
companyReqVo.setId(userVo.getCompanyId());
CompanyVo companyVo = companyDaoImpl.load(companyReqVo,CompanyVo.class);

// 加载公司银行卡
CompanyBankCardVo companyBankCardReqVo = new CompanyBankCardVo();
companyBankCardReqVo.setCompanyId(userVo.getCompanyId());
CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(companyBankCardReqVo,CompanyBankCardVo.class);

// 加载公司扩展信息，这里有没有可能1对多?
CompanyExtendVo companyExtendReqVo = new CompanyExtendVo();
companyExtendReqVo.setId(userVo.getCompanyId());
CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(companyExtendReqVo,CompanyExtendVo.class);

```


# 删除函数可以简化
``` java 

roleDao.remove(roleVo);

UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
userRoleGetReqVo.setRoleId(roleVo.getId());
List<UserRoleVo> userRoleList = userRoleDaoImpl.getUserRoleList(userRoleGetReqVo);
if (userRoleList != null && userRoleList.size() != 0){
    for (UserRoleVo userRoleRelation:userRoleList) {
        userRoleDaoImpl.remove(userRoleRelation);
    }
}

RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
reqVo.setRoleId(roleVo.getId());
List<RoleAuthorityVo> roleAuthorityList = roleAuthorityDaoImpl.getRoleAuthorityList(reqVo);
if (roleAuthorityList != null && roleAuthorityList.size() != 0){
    for (RoleAuthorityVo roleAuthority:roleAuthorityList) {
        roleAuthorityDaoImpl.remove(roleAuthority);
    }
}

// 这里得移动到前面，先删除子元素，在删除当前元素
RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
roleGetReqVo.setId(roleVo.getId());
List<RoleVo> childList = roleDao.getChild(roleGetReqVo);
for (RoleVo child:childList) {
    this.deleteRole(child);
}
```
改成
``` java 
// 先删除子角色，并且不需要写SQL语句
RoleVo childReq = new RoleVo();
childReq.setPid(roleVo.getId());
List<RoleVo> childList  = roleDao.loadList(childReq,RoleVo.class);
for (RoleVo child:childList) {
    this.deleteRole(child);
}

// 删除当前元素
roleDao.remove(roleVo);

// 删除用户角色关联
UserRoleGetReqVo userRoleGetReqVo = new UserRoleGetReqVo();
userRoleGetReqVo.setRoleId(roleVo.getId());
userRoleDaoImpl.remove(userRoleGetReqVo);

// 删除角色权限
RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
reqVo.setRoleId(roleVo.getId());
roleAuthorityDaoImpl.remove(reqVo);
```

# 建议load函数直接调用,这些函数可以删除
``` java 
@Override
public RoleVo getRoleById(RoleGetReqVo roleGetReqVo) {
    return this.load(roleGetReqVo,RoleVo.class);
}

@Override
public RoleVo getRoleByRoleName(RoleGetReqVo getRoleByRoleNameReqVo) {
    return this.load(getRoleByRoleNameReqVo, RoleVo.class);
}
```
如下代码改成：
``` java 

@Override
public WebRoleResVo getRoleById(WebRoleReqVo webRoleReqVo) {
    RoleGetReqVo roleGetReqVo = new RoleGetReqVo();
    roleGetReqVo.setId(webRoleReqVo.getId());
    RoleVo roleVo = roleDao.getRoleById(roleGetReqVo);
    if (roleVo == null){
        throw new CodeException("未找到该角色");
    }
    List<AuthorityVo> authorityList = this.getAuthorityListByRoleId(webRoleReqVo.getId());
    return this.makeResVo(roleVo,authorityList);
}


@Override
public WebRoleResVo makeResVo(RoleVo roleVo, List<AuthorityVo> authorityList) {
    WebRoleResVo resVo = new WebRoleResVo();
    resVo.setId(roleVo.getId());
    resVo.setName(roleVo.getName());
    resVo.setPid(roleVo.getPid());
    resVo.setRemark(roleVo.getRemark());
    resVo.setAuthorityList(authorityList);
    return resVo;
}

@Override
public List<AuthorityVo> getAuthorityListByRoleId(String roleId) {
    RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
    reqVo.setRoleId(roleId);
    List<RoleAuthorityVo> roleAuthorityRelationList = roleAuthorityDaoImpl.getRoleAuthorityList(reqVo);
    if (roleAuthorityRelationList != null && roleAuthorityRelationList.size() != 0){
        List<AuthorityVo> authorityList = new ArrayList(roleAuthorityRelationList.size());
        for (RoleAuthorityVo roleAuthorityRelation:roleAuthorityRelationList) {
            AuthorityGetReqVo authorityGetReqVo = new AuthorityGetReqVo();
            authorityGetReqVo.setId(roleAuthorityRelation.getAuthorityId());
            AuthorityVo authorityVo = authorityDaoImpl.load(authorityGetReqVo,AuthorityVo.class);
            authorityList.add(authorityVo);
        }
        return authorityList;
    }
    return null;
}
```
改成:
``` java 

@Override
public WebRoleResVo getRoleById(WebRoleReqVo webRoleReqVo) {
    WebRoleResVo roleVo = roleDao.load(webRoleReqVo,WebRoleResVo.class);
    if (roleVo == null){
        throw new CodeException("未找到该角色");
    }
    RoleAuthorityGetReqVo reqVo = new RoleAuthorityGetReqVo();
    reqVo.setRoleId(roleVo.getId());
    
    List<AuthorityVo> authorityList = authorityDaoImpl.loadList(reqVo,AuthorityVo.class);
    roleVo.setAuthorityList(authorityList);
    return roleVo;
}

在 authorityDaoImpl 修改load语句
this.getSql(DaoConst.LOAD).add("roleId","{INNER}","INNER JOIN RoleAuthorityVo as b ON a.id = b.AuthorityId AND b.roleId = ?");
```