package com.pangding.web.tright.dao;

import com.pangding.web.tright.vo.TrightVo;
import com.yanzuoguang.dao.BaseDao;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface TrightDao extends BaseDao {

    /**
     * 检查新建或修改的TrightVo对象是否合法
     *
     * @param trightVo TrightVo对象
     * @return 0：合法 else：不合法
     */
    int checkValid(TrightVo trightVo);

    /**
     * 根据主键获取TrightVo对象
     *
     * @param id 主键
     * @return TrightVo对象
     */
    TrightVo getTrightById(String id);

    /**
     * 获取TrightVo对象列表
     *
     * @return TrightVo对象列表
     */
    List<TrightVo> listAll();

    /**
     * 获取一级权限列表
     *
     * @return 一级权限列表
     */
    List<TrightVo> listLevel1();

    /**
     * 通过权限表主键查询是否拥有子权限
     *
     * @param id 主键
     * @return 0：没有子权限 else：子权限个数
     */
    int checkChild(String id);

    /**
     * 通过权限表主键获取子权限id列表
     *
     * @param id 主键
     * @return 子权限id列表
     */
    List<String> getChildIdList(String id);
}
