package com.pangding.web.authority.controller;


import com.pangding.web.authority.vo.UserVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.vo.resvo.WebUserResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping(value = "/user")
public class UserController {

    @Autowired
    UserService userServiceImpl;

    /**
     * 新增用户
     * 返回用户id
     * @param webUserReqVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> saveUser(@RequestBody WebUserReqVo webUserReqVo) throws Exception {
        CheckerHelper.newInstance()
                .notBlankCheck("account",webUserReqVo.getAccount())
                .notBlankCheck("password",webUserReqVo.getPassword())
                .notBlankCheck("confirmPassword",webUserReqVo.getConfirmPassword())
                .checkPhoneNo("phone",webUserReqVo.getPhone())
                .notBlankCheck("companyId",webUserReqVo.getCompanyId())
                .notBlankCheck("email",webUserReqVo.getEmail())
                .checkException();
        return ResponseResult.result(userServiceImpl.saveUser(webUserReqVo));
    }

    /**
     * 修改用户信息
     * 返回用户id
     * @param
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<String> updateUser(@RequestBody WebUserReqVo webUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("account",webUserReqVo.getAccount())
                .notBlankCheck("password",webUserReqVo.getPassword())
                .checkPhoneNo("phone",webUserReqVo.getPhone())
                .notBlankCheck("companyId",webUserReqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(userServiceImpl.updateUser(webUserReqVo));
    }

    /**
     * 查询用户列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebUserResVo>> listUsers(ListUserReqVo reqVo){
        return ResponseResult.result(userServiceImpl.getWebUserResVoList(reqVo));
    }

    /**
     * 根据ID查询用户
     * @param //id
     * @return
     */
    @RequestMapping(value = "/user", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<WebUserResVo> user(@RequestBody WebUserReqVo webUserReqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("userId",webUserReqVo.getId())
                .checkException();
        return ResponseResult.result(userServiceImpl.getUserById(webUserReqVo.getId()));
    }
}
