package com.pangding.web.authority.controller;


import com.pangding.web.authority.currency.Result;
import com.pangding.web.authority.service.AuthorityService;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityReqVo;
import com.pangding.web.authority.vo.reqvo.WebAuthorityReqVo;
import com.pangding.web.authority.vo.reqvo.WebAuthorityResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/authority")
public class AuthorityController {

    @Autowired
    AuthorityService authorityServiceImpl;

    /**
     * 新增权限
     * @param authorityVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveAuthority(@RequestBody AuthorityVo authorityVo){
        authorityServiceImpl.save(authorityVo);
        return new ResponseResult();
    }

    /**
     * 修改权限信息
     * @param authorityVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult updateAuthority(@RequestBody AuthorityVo authorityVo){
        authorityServiceImpl.update(authorityVo);
        return new ResponseResult();
    }

    /**
     * 查询权限列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebAuthorityResVo>> listAuthoritys(ListAuthorityReqVo reqVo){
        return ResponseResult.result(authorityServiceImpl.getWebAuthorityResVoList(reqVo));
    }

    /**
     * 查询一级权限
     * @return
     */
    @RequestMapping(value = "/firstLevel", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebAuthorityResVo>> parentAuthoritys(ListAuthorityReqVo reqVo){
        return ResponseResult.result(authorityServiceImpl.getWebAuthorityResVoList(reqVo));
    }

    /**
     * 根据ID查询权限
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<AuthorityVo> authority(@RequestBody WebAuthorityReqVo reqVo){
        return ResponseResult.result(authorityServiceImpl.getAuthorityById(reqVo));
    }

    /**
     * 删除权限
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult delete(@RequestBody WebAuthorityReqVo reqVo){
        authorityServiceImpl.deleteAuthorityById(reqVo);
        return new ResponseResult();

    }
}


