package com.pangding.web.authority.controller;


import com.pangding.web.authority.vo.reqvo.ListRoleReqVo;
import com.pangding.web.authority.vo.reqvo.WebRoleReqVo;
import com.pangding.web.authority.service.RoleService;
import com.pangding.web.authority.vo.reqvo.WebRoleResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;


/**
 * @author zhangjinyao
 */
@RestController
@RequestMapping("/roles")
public class RoleController {

    @Autowired
    RoleService roleServiceImpl;

    /**
     * 新增角色
     * @param webRoleReqVo
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult saveRole(@RequestBody WebRoleReqVo webRoleReqVo){
        roleServiceImpl.saveRole(webRoleReqVo);
        return new ResponseResult();
    }

    /**
     * 修改角色信息
     * @param webRoleReqVo
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult updateRole(@RequestBody WebRoleReqVo webRoleReqVo){
        roleServiceImpl.updateRole(webRoleReqVo);
        return new ResponseResult();
    }

    /**
     * 查询角色列表
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<PageSizeData<WebRoleResVo>> listRoles(@RequestBody ListRoleReqVo req){
        return ResponseResult.result(roleServiceImpl.getWebRoleResVoList(req));
    }

    /**
     * 根据ID查询角色
     * @param
     * @return
     */
    @RequestMapping(value = "/role", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<WebRoleResVo> getRoleById(@RequestBody WebRoleReqVo webRoleReqVo){
        return ResponseResult.result(roleServiceImpl.getRoleById(webRoleReqVo));
    }

    /**
     * 删除角色
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult delete(@RequestBody WebRoleReqVo webRoleReqVo){
        roleServiceImpl.delete(webRoleReqVo);
        return new ResponseResult();
    }
}
