package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.reqvo.AuthorityGetReqVo;
import com.pangding.web.authority.reqvo.ListLevel1ReqVo;
import com.pangding.web.authority.vo.AuthorityVo;
import com.pangding.web.authority.vo.reqvo.ListAuthorityReqVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface AuthorityDao extends BaseDao {

    /**
     * 检查新建或修改的authorityVo对象是否合法
     *
     * @param authorityVo authorityVo对象
     */
    void checkValid(AuthorityVo authorityVo);

    /**
     * 根据主键获取authorityVo对象
     *
     * @param authorityGetReqVo 主键
     * @return authorityVo对象
     */
    AuthorityVo getAuthority(AuthorityGetReqVo authorityGetReqVo);

    PageSizeData<AuthorityVo> getAuthorityList(ListAuthorityReqVo reqVo);

    List<AuthorityVo> getAuthoritys(AuthorityGetReqVo reqVo);
    /**
     * 获取authorityVo对象列表
     *
     * @return authorityVo对象列表
     */
    List<AuthorityVo> listAll();


    /**
     * 获取一级权限对象列表
     *
     * @param listLevel1ReqVo ListLevel1ReqVo对象，仅用于拼接sql语句查询条件，无实际意义
     * @return 权限对象列表
     */
    List<AuthorityVo> listLevel1(ListLevel1ReqVo listLevel1ReqVo);
}
