package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.RoleDao;
import com.pangding.web.tright.dao.RoleTrightDao;
import com.pangding.web.tright.dao.UserRoleDao;
import com.pangding.web.tright.dto.RoleDto;
import com.pangding.web.tright.service.RoleService;
import com.pangding.web.tright.vo.RoleTrightRelation;
import com.pangding.web.tright.vo.RoleVo;
import com.pangding.web.tright.vo.UserRoleRelation;
import com.yanzuoguang.util.helper.CheckerHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    RoleDao roleDao;

    @Autowired
    UserRoleDao userRoleDaoImpl;

    @Autowired
    RoleTrightDao roleTrightDaoImpl;

    @Override
    public void saveRole(RoleVo roleVo) {
        roleDao.create(roleVo);
    }

    @Override
    public RoleVo getRoleById(String id) {
        return roleDao.getRoleById(id);
    }

    @Override
    public RoleVo getRoleByName(String name) {
        return roleDao.getRoleByName(name);
    }

    @Override
    public void roleAndTright(RoleDto roleDto) {
        List<String> trightIds = roleDto.getTrightIds();
        for (String trightId : trightIds) {
            RoleTrightRelation roleTrightRelation = new RoleTrightRelation();
            roleTrightRelation.setTrightId(trightId);
            roleTrightRelation.setRoleId(roleDto.getId());
            roleTrightRelation.setId(UUID.randomUUID().toString());
            roleTrightDaoImpl.create(roleTrightRelation);
        }
    }

    @Override
    public Boolean checkNameExist(RoleVo roleVo) {
        if (roleDao.checkNameExist(roleVo) > 0){return false;}
        return true;
    }

    @Override
    public List<RoleVo> getRoleVoList() {
        return roleDao.getRoleVoList();
    }

    @Override
    public List<String> getTrightIdList(String roleId) {
        return roleDao.getTrightIdList(roleId);
    }

    @Override
    public String getTrightNameByTrightId(String trightId) {
        return roleDao.getTrightNameByTrightId(trightId);
    }

    @Override
    public RoleDto makeRoleDto(RoleVo roleVo, List<String> trightIdList, List<String> trightNameList) {
        RoleDto roleDto = (RoleDto) roleVo;
        roleDto.setTrightIds(trightIdList);
        roleDto.setTrightNames(trightNameList);
        return roleDto;
    }

    @Override
    public void deleteRole(String roleId) {
        roleDao.remove(roleId);
    }

    @Override
    public void deleteRoleUser(String id) {
        if (id != null && id != "") {
            userRoleDaoImpl.remove(id);
        }
    }

    @Override
    public void deleteRoleTright(String id) {
        if (id != null && id != "") {
            roleTrightDaoImpl.remove(id);
        }
    }

    @Override
    public String getRoleUserPKByRoleId(String roleId) {
        return userRoleDaoImpl.getPKByRoleId(roleId);
    }

    @Override
    public String getRoleTrightPKByRoleId(String roleId) {
        return roleTrightDaoImpl.getPKByRoleId(roleId);
    }
}
