package com.pangding.web.tright.service.impl;

import com.pangding.web.tright.dao.UserDao;
import com.pangding.web.tright.dto.UserDto;
import com.pangding.web.tright.service.UserService;
import com.pangding.web.tright.vo.UserRoleRelation;
import com.pangding.web.tright.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserDao userDao;

    @Override
    public List<UserVo> listUserVo() {
//        return userDao.listUser();
        return userDao.listUserVo();
    }

    @Override
    public void userAndRole(UserDto userDto) {

        List<String> roleIds = userDto.getRoleIds();//多个角色

        for (String roleId : roleIds) {
            UserRoleRelation userRoleRelation = new UserRoleRelation();
            userRoleRelation.setRoleId(roleId);
            userRoleRelation.setUserId(userDto.getId());
            userRoleRelation.setId(UUID.randomUUID().toString());
            userDao.create(userRoleRelation);
        }

    }


    @Override
    public UserVo getUser(UserVo userVo) {
        return userDao.getUser(userVo);
    }

    @Override
    public String passwordEncoder(String credentials, String salt) {
        return null;
    }

    @Override
    public List<String> listRoleIdList(UserVo userVo) {
        return userDao.getRoleIdList(userVo);
    }

    @Override
    public UserDto makeUserDto(UserVo userVo, List<String> roleIdList, List<String> roleList) {
        UserDto userDto = (UserDto) userVo;
        userDto.setRoleIds(roleIdList);
        userDto.setRoles(roleList);
        return userDto;
    }

    @Override
    public String getRoleByRoleId(String roleId) {
        return userDao.getRoleByRoleId(roleId);
    }

    @Override
    public UserVo getUserById(String userId) {
        return userDao.getUserById(userId);
    }
}
