package com.pangding.web.authority.dao.company.impl;

import com.pangding.web.authority.dao.company.CompanyDao;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyNumberResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.dao.DaoConst;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:25
 */
@Component
public class CompanyDaoImpl extends BaseDaoImpl implements CompanyDao {

    private static final String QUERY_COMPANY = "QUERY_COMPANY";

    private static final String QUERY_COMPANY_TOTAL= "QUERY_COMPANY_TOTAL";

    @Override
    protected void init() {

        register(CompanyVo.class);

        getSql(DaoConst.LOAD).addCode("{FIELD}", ",b.*", "{INNER}", "INNER JOIN pd_company_extend b ON a.id = b.id");

        table.add(QUERY_COMPANY,"select a.*,b.subledger_status,b.subledger_rule,b.subledger_rule_time,b.divide_status,b.scan_code_pay_status," +
                "invitation_status,invitation_rule_id,invitation_code,invitees_people,invited_people,activation_status,withdraw_rule,min_withdraw_money," +
                "max_withdraw_money,withdraw_fee,withdraw_type,grade,withdraw_total_cash,frozen_money,discount_rule," +
                "service_charge_status,service_charge_type,service_charge,late_fee " +
                " from pd_company a inner join pd_company_extend b on a.id = b.id " +
                "where 1=1 {WHERE} order by create_time desc")
                .add("province"," and province = ? ")
                .add("city"," and city = ? ")
                .add("area"," and area = ? ")
                .add("companyName"," and company_name LIKE concat('%', ?,'%')  ")
                .add("companyType"," and company_type = ? ")
                .add("companyAttribute"," and company_attribute = ? ")
                .add("examineStatus"," and examine_status = ?")
                .add("companyId"," and invitation_company_id = ? ")
                .add("invitationCode"," and (invitation_code = ? or child_invitation_code = ?) ")
                .add("contactName"," and contact_name LIKE concat('%', ?,'%') ")
                .add("contactPhone"," and contact_phone = ? ")
                .add("status"," and status = ? ")
                .add("withdrawRule"," and withdraw_rule = ? ")
                .add("serviceChargeStatus"," and service_charge_status = ? ")
                .add("startDate"," and create_time >= ? ")
                .add("endDate"," and create_time <= ? ")
                .add("search"," and (company_name LIKE concat('%', ?,'%')  or (contact_name LIKE concat('%', ?,'%') )");

        table.add(QUERY_COMPANY_TOTAL,"select COUNT(a.id) AS company_num," +
                "SUM(CASE WHEN examine_status = 2 THEN 1 ELSE 0 END) AS company_use_num " +
                " from pd_company a inner join pd_company_extend b on a.id = b.id " +
                "where 1=1 {WHERE} order by create_time desc")
                .add("province"," and province = ? ")
                .add("city"," and city = ? ")
                .add("area"," and area = ? ")
                .add("companyName"," and company_name LIKE concat('%', ?,'%')  ")
                .add("companyType"," and company_type = ? ")
                .add("companyAttribute"," and company_attribute = ? ")
                .add("examineStatus"," and examine_status = ?")
                .add("companyId"," and invitation_company_id = ? ")
                .add("invitationCode"," and (invitation_code = or chlid_invitation_code) ")
                .add("contactName"," and contact_name LIKE concat('%', ?,'%') ")
                .add("contactPhone"," and contact_phone = ? ")
                .add("status"," and status = ? ")
                .add("withdrawRule"," and withdraw_rule = ? ")
                .add("serviceChargeStatus"," and service_charge_status = ? ")
                .add("startDate"," and create_time >= ? ")
                .add("endDate"," and create_time <= ? ")
                .add("search"," and (company_name LIKE concat('%', ?,'%')  or (contact_name LIKE concat('%', ?,'%') )");

    }

    @Override
    public PageSizeData<CompanyResVo> findCompanyListPage(CompanyReqVo reqVo) {
        return this.queryPage(CompanyResVo.class,reqVo,QUERY_COMPANY,reqVo);
    }

    @Override
    public List<CompanyResVo> findCompanyList(CompanyReqVo req) {
        return this.query(CompanyResVo.class, QUERY_COMPANY, req);
    }

    @Override
    public CompanyResVo findCompany(CompanyReqVo req) {
        return this.queryFirst(CompanyResVo.class, QUERY_COMPANY, req);
    }

    @Override
    public CompanyNumberResVo findCompanyTotal(CompanyReqVo req) {
        return this.queryFirst(CompanyNumberResVo.class, QUERY_COMPANY_TOTAL, req);
    }
}
