package com.pangding.web.authority.service.company;

import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.req.company.SaveCompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyPageResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.util.vo.ResponseResult;

import java.util.List;

public interface NewCompanyService {

    /**
     * 查询公司列表（分页）
     * @param req
     * @return
     */
    CompanyPageResVo findCompanyListPage(CompanyReqVo req);

    /**
     * 查询公司列表
     * @param req
     * @return
     */
    List<CompanyResVo> findCompanyList(CompanyReqVo req);

    /**
     * 找到公司详情信息
     * @param req
     * @return
     */
    CompanyResVo findCompany(CompanyReqVo req);

    /**
     * 修改公司信息 （实名认证）
     * @param req
     * @return
     */
    ResponseResult<SaveCompanyReqVo> updateCompanyInfo(SaveCompanyReqVo req);


    /**
     * 检查邀请码是否正确和邀请是否符合邀请规则
     *
     * @param invitationCode
     */
    CompanyResVo checkInvitationCode(String invitationCode);

}
