package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.IndexService;
import com.pangding.web.authority.vo.reqvo.TotalIncomeReqVo;
import com.pangding.web.authority.vo.reqvo.WithdrawCashReqVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * @Author zhangjinyao
 * @create 2019/5/27 10:47
 */
@RestController
@RequestMapping(value="/index")
public class IndexController {
    @Autowired
    IndexService indexServiceImpl;

    /**
     * 通过公司id获取该公司的可提现余额
     * @param reqVo 封装了公司id的请求对象
     * @return 可提现的金额
     */
    @PostMapping(value = "/withdrawCash", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<BigDecimal> withdrawCash(@RequestBody WithdrawCashReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getWithdrawCash(reqVo));
    }

    /**
     * 通过公司id获取该公司累积总收益
     * @param reqVo 封装了公司id的请求对象
     * @return 累计总收益
     */
    @PostMapping(value = "/totalIncome", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<BigDecimal> totalIncome(@RequestBody TotalIncomeReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getId())
                .checkException();
        return ResponseResult.result(indexServiceImpl.getTotalIncome(reqVo));
    }
}
