package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.DeviceService;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.res.DeviceResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author tangfang
 * @date 2020-08-19
 */
@Api(value = "设备类", description = "设备的查询，新增，修改，删除等相关操作")
@RestController
@RequestMapping("/device")
public class DevideController {

    @Autowired
    private DeviceService deviceService;

    @RequestMapping(value = "/findDeviceList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "获取设备列表", notes = "返回设备列表")
    public ResponseResult<PageSizeData<DeviceResVo>> findDeviceList(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.findDeviceList(req);
    }


    @RequestMapping(value = "/findDeviceInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "获取设备信息", notes = "返回设备信息")
    public ResponseResult<DeviceResVo> findDeviceInfo(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.findDeviceInfo(req);
    }

    @RequestMapping(value = "/findDeviceInfoByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "根据设备编号获取设备信息", notes = "返回设备信息")
    public ResponseResult<DeviceResVo> findDeviceInfoByCode(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.findDeviceInfoByCode(req);
    }

    @RequestMapping(value = "/saveDevice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "保存设备信息", notes = "返回保存结果")
    public ResponseResult saveDevice(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.saveDevice(req);
    }

    @RequestMapping(value = "/updateDevice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "修改设备信息", notes = "返回修改结果")
    public ResponseResult updateDevice(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.updateDevice(req);
    }

    @RequestMapping(value = "/delDevice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ApiOperation(value = "删除设备信息", notes = "返回删除结果")
    public ResponseResult delDevice(@RequestBody DeviceReqVo req){
//        CheckerHelper.newInstance().notBlankCheck("id",req.getId()).checkException();
        return deviceService.delDevice(req);
    }

}
