package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.UserRoleDao;
import com.pangding.web.authority.vo.reqvo.UserRoleGetReqVo;
import com.pangding.web.authority.vo.UserRoleVo;
import com.pangding.web.authority.vo.resvo.WebRoleResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhangjinyao
 */
@Component
public class UserRoleDaoImpl extends BaseDaoImpl implements UserRoleDao {

    private static final String GET_USER_ROLE_LIST = "GET_USER_ROLE_LIST";

    private static final String GET_ROLE_USER_NUMBER = "GET_ROLE_USER_NUMBER";

    @Override
    protected void init() {

        register(UserRoleVo.class);

        table.add(GET_USER_ROLE_LIST,"select * from pd_user_role where 1=1 ")
                .add("userId","and user_id = ? ")
                .add("roleId","and role_id = ? ");

        table.add(GET_ROLE_USER_NUMBER,"select count(*),role_id from pd_user_role where 1=1 {WHERE} group by role_id ")
                .add("userId","and user_id = ? ")
                .add("roleIds","and role_id in ? ");

    }

    @Override
    public List<UserRoleVo> getUserRoleList(UserRoleGetReqVo reqVo) {
        return this.query(UserRoleVo.class,GET_USER_ROLE_LIST,reqVo);
    }

    @Override
    public List<WebRoleResVo> getUserNum(UserRoleGetReqVo reqVo) {
        return this.query(WebRoleResVo.class,GET_ROLE_USER_NUMBER,reqVo);
    }

}
