package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyKeyDao;
import com.pangding.web.authority.dao.TokenDao;
import com.pangding.web.authority.service.TokenService;
import com.pangding.web.vo.system.pd.LoginTokenVo;
import com.pangding.web.vo.system.req.company.CompanyKeyReqVo;
import com.pangding.web.vo.system.res.company.CompanyKeyResVo;
import com.yanzuoguang.util.helper.JsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 登录写入服务类
 *
 * @author 颜佐光
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class TokenServiceImpl implements TokenService {

    @Autowired
    private TokenDao tokenDao;
    @Autowired
    private CompanyKeyDao companyKeyDao;

    @Override
    public CompanyKeyResVo getCompanyKey(CompanyKeyReqVo companyKeyReqVo){
        CompanyKeyResVo companyKeyResVo = companyKeyDao.load(companyKeyReqVo, CompanyKeyResVo.class);
        return companyKeyResVo;
    }


    /**
     * 保存接口请求日志
     *
     * @param loginVo
     */
    @Override
    public String save(LoginTokenVo loginVo) {
        LoginTokenVo to = tokenDao.load(loginVo, LoginTokenVo.class);
        if (JsonHelper.compare(to,loginVo)) {
            return to.getToken();
        } else if (to != null) {
            return tokenDao.update(loginVo);
        } else {
            return tokenDao.create(loginVo);
        }
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo 请求数据
     * @retur 保存主键
     */
    @Override
    public LoginTokenVo load(LoginTokenVo loginVo) {
        return tokenDao.load(loginVo, LoginTokenVo.class);
    }

    /**
     * 保存接口请求日志
     *
     * @param loginVo 请求数据
     * @retur 保存主键
     */
    @Override
    public int remove(LoginTokenVo loginVo) {

        return tokenDao.remove(loginVo);
    }

}
