package com.tcm.common.dao.impl;

import com.tcm.common.dao.FloorDao;
import com.tcm.util.area.FloorVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class FloorDaoImpl extends BaseDaoImpl implements FloorDao {

    private static final String SQL_LOAD_BY_SORT = "load_by_sort";

    @Override
    protected void init() {
        register(FloorVo.class);
        table.add(SQL_LOAD_BY_SORT, "select p.*,pe.floor_name as floorName,pe.floor_desc as floorDesc from tcm_floor as p " +
                " left join tcm_floor_extend as pe on p.floor_id = pe.floor_id where 1=1 {WHERE} order by sort")
                .add("floorId", "and p.floor_id =?")
                .add("floorName", "and p.floor_name =?")
                .add("floorStatus", "and p.floor_status =?")
                .add("languageType", "and pe.language_type =?")
        ;
    }

    @Override
    public List<FloorResVo> loadBySort(FloorReqVo req) {
        return this.query(FloorResVo.class, SQL_LOAD_BY_SORT, req);
    }

    @Override
    public PageSizeData<FloorResVo> loadByPage(FloorLoadPageReqVo req) {
        return this.queryPage(FloorResVo.class, req, SQL_LOAD_BY_SORT, req);
    }

    @Override
    public FloorResVo loadInfo(FloorReqVo req) {
        return this.queryFirst(FloorResVo.class, SQL_LOAD_BY_SORT, req);
    }
}
