package com.tcm.common.service.impl;

import com.tcm.common.dao.FloorAreaDao;
import com.tcm.common.dao.FloorAreaExtendDao;
import com.tcm.common.dao.FloorDao;
import com.tcm.common.dao.impl.FloorExtendDao;
import com.tcm.common.service.AreaService;
import com.tcm.common.service.CarouselService;
import com.tcm.common.service.ImageService;
import com.tcm.common.util.CommonConstant;
import com.tcm.util.area.FloorAreaExtendVo;
import com.tcm.util.area.FloorAreaVo;
import com.tcm.util.area.FloorExtendVo;
import com.tcm.util.area.FloorVo;
import com.tcm.util.area.req.FloorAreaLoadPageReqVo;
import com.tcm.util.area.req.FloorAreaReqVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.tcm.util.area.res.FloorHomeLoadResVo;
import com.tcm.util.area.res.FloorResVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.tcm.util.common.res.ImageResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AreaServiceImpl implements AreaService {

    private final FloorDao floorDao;
    private final FloorAreaDao floorAreaDao;
    private final ImageService imageService;
    private final CarouselService carouselService;
    private final FloorExtendDao floorExtendDao;
    private final FloorAreaExtendDao floorAreaExtendDao;


    public AreaServiceImpl(FloorDao floorDao,
                           FloorAreaDao floorAreaDao,
                           ImageService imageService,
                           CarouselService carouselService,
                           FloorExtendDao floorExtendDao,
                           FloorAreaExtendDao floorAreaExtendDao) {
        this.floorDao = floorDao;
        this.floorAreaDao = floorAreaDao;
        this.imageService = imageService;
        this.carouselService = carouselService;
        this.floorExtendDao = floorExtendDao;
        this.floorAreaExtendDao = floorAreaExtendDao;
    }

    @Override
    public String floorSave(FloorReqVo req) {
        if (StringHelper.isEmpty(req.getFloorId())) {
            FloorVo floor = new FloorVo();
            String floorId = StringHelper.getNewID();
            floor.setFloorId(floorId);
            ObjectHelper.writeWithFrom(floor, req);
            floor.setCreateTime(DateHelper.getNow());
            floorDao.create(floor);

            FloorExtendVo floorExtendVo = new FloorExtendVo();
            floorExtendVo.setFloorId(floorId);
            ObjectHelper.writeWithFrom(floorExtendVo, req.getFloorExtendVo());
            floorExtendVo.setFloorExtendId(StringHelper.getNewID());
            floorExtendDao.create(floorExtendVo);

            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(floorId);
            imageReqVo.setImageList(req.getImageList());
            imageService.saveList(imageReqVo);

            return floorId;
        } else {
            FloorVo floor = new FloorVo();
            floor.setFloorId(req.getFloorId());
            FloorVo load = floorDao.load(floor, FloorVo.class);
            ObjectHelper.writeWithFrom(load, req);
            floorDao.update(load);

            FloorExtendVo floorExtendVo = new FloorExtendVo();
            floorExtendVo.setFloorId(req.getFloorId());
            floorExtendVo.setLanguageType(req.getFloorExtendVo().getLanguageType());
            FloorExtendVo loadExtend = floorExtendDao.load(floorExtendVo, FloorExtendVo.class);
            if (loadExtend == null) {
                floorExtendVo.setFloorExtendId(StringHelper.getNewID());
                floorExtendDao.create(floorExtendVo);
            } else {
                ObjectHelper.writeWithFrom(loadExtend, req.getFloorExtendVo());
                floorExtendDao.update(loadExtend);
            }
            //删除老图片
            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(req.getFloorId());
            imageService.remove(imageReqVo);

            imageReqVo.setImageList(req.getImageList());
            imageService.saveList(imageReqVo);

            return req.getFloorId();
        }
    }

    @Override
    public FloorResVo floorLoad(FloorReqVo req) {
        FloorReqVo floor = new FloorReqVo();
        floor.setFloorId(req.getFloorId());
        floor.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
        FloorResVo load = floorDao.loadInfo(floor);
        FloorExtendVo floorExtendVo = new FloorExtendVo();
        floorExtendVo.setFloorId(req.getFloorId());
        floorExtendVo.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
        load.setFloorExtendVo(floorExtendDao.load(floorExtendVo, FloorExtendVo.class));

        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(load.getFloorId());
        load.setImageResVoList(imageService.loadList(imageReqVo));

        FloorAreaReqVo areaReqVo = new FloorAreaReqVo();
        areaReqVo.setFloorId(req.getFloorId());
        areaReqVo.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
        List<FloorAreaResVo> floorAreaResVoList = floorAreaDao.loadBySort(areaReqVo);
        FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
        for (FloorAreaResVo floorAreaResVo : floorAreaResVoList) {
            areaExtendVo.setAreaId(floorAreaResVo.getAreaId());
            floorAreaResVo.setAreaExtendVo(floorAreaExtendDao.load(areaExtendVo, FloorAreaExtendVo.class));

            imageReqVo.setRelationId(floorAreaResVo.getAreaId());
            floorAreaResVo.setImageList(imageService.loadList(imageReqVo));
        }
        load.setFloorAreaVoList(floorAreaResVoList);

        return load;
    }

    @Override
    public PageSizeData<FloorResVo> floorLoadPage(FloorLoadPageReqVo req) {
        PageSizeData<FloorResVo> page = floorDao.loadByPage(req);
        for (FloorResVo floorResVo : page.getList()) {
            FloorExtendVo floorExtendVo = new FloorExtendVo();
            floorExtendVo.setFloorId(floorResVo.getFloorId());
            floorExtendVo.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
            floorResVo.setFloorExtendVo(floorExtendDao.load(floorExtendVo, FloorExtendVo.class));
        }

        return page;
    }

    @Override
    public String floorRemove(FloorReqVo req) {
        //楼层删除
        FloorVo floor = new FloorVo();
        floor.setFloorId(req.getFloorId());
        floorDao.remove(floor);

        FloorExtendVo floorExtendVo = new FloorExtendVo();
        floorExtendVo.setFloorId(req.getFloorId());
        floorExtendDao.remove(floorExtendVo);

        //楼层图片删除
        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getFloorId());
        imageService.remove(imageReqVo);

        //区域删除
        FloorAreaVo areaVo = new FloorAreaVo();
        areaVo.setFloorId(req.getFloorId());
        List<FloorAreaVo> areaList = floorAreaDao.loadList(areaVo, FloorAreaVo.class);
        for (FloorAreaVo floorAreaVo : areaList) {
            //扩展信息删除
            FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
            areaExtendVo.setAreaId(floorAreaVo.getAreaId());
            floorAreaExtendDao.remove(areaExtendVo);
        }
        floorAreaDao.remove(areaVo);
        //区域图片删除
        for (FloorAreaVo floorAreaVo : areaList) {
            ImageReqVo areaImageReqVo = new ImageReqVo();
            areaImageReqVo.setRelationId(floorAreaVo.getAreaId());
            imageService.remove(imageReqVo);
        }
        return req.getFloorId();
    }

    @Override
    public FloorAreaResVo areaLoad(FloorAreaReqVo req) {
        FloorAreaReqVo areaVo = new FloorAreaReqVo();
        areaVo.setAreaId(req.getAreaId());
        areaVo.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
        FloorAreaResVo load = floorAreaDao.loadInfo(areaVo);

        FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
        areaExtendVo.setAreaId(req.getAreaId());
        areaExtendVo.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
        load.setAreaExtendVo(floorAreaExtendDao.load(areaExtendVo, FloorAreaExtendVo.class));

        ImageReqVo imageReq = new ImageReqVo();
        imageReq.setRelationId(load.getAreaId());
        List<ImageResVo> images = imageService.loadList(imageReq);
        load.setImageList(images);
        return load;
    }

    @Override
    public String areaSave(FloorAreaReqVo req) {
        if (StringHelper.isEmpty(req.getAreaId())) {
            FloorAreaVo areaVo = new FloorAreaVo();
            String areaId = StringHelper.getNewID();
            areaVo.setFloorId(areaId);
            ObjectHelper.writeWithFrom(areaVo, req);
            areaVo.setCreateTime(DateHelper.getNow());
            floorAreaDao.create(areaVo);

            FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
            areaExtendVo.setAreaId(areaId);
            areaExtendVo.setAreaExtendId(StringHelper.getNewID());
            ObjectHelper.writeWithFrom(areaExtendVo, req.getFloorAreaExtendVo());
            floorAreaExtendDao.create(areaExtendVo);

            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(areaId);
            imageReqVo.setImageList(req.getImageVoList());
            imageService.saveList(imageReqVo);

            return areaId;
        } else {
            FloorAreaVo areaVo = new FloorAreaVo();
            areaVo.setAreaId(req.getAreaId());
            FloorAreaVo load = floorAreaDao.load(areaVo, FloorAreaVo.class);
            ObjectHelper.writeWithFrom(load, req);
            floorAreaDao.update(load);

            FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
            areaExtendVo.setAreaId(req.getAreaId());
            areaExtendVo.setLanguageType(req.getFloorAreaExtendVo().getLanguageType());
            FloorAreaExtendVo loadExtend = floorAreaExtendDao.load(areaExtendVo, FloorAreaExtendVo.class);
            if (loadExtend == null) {
                //新增
                areaExtendVo.setAreaExtendId(StringHelper.getNewID());
                ObjectHelper.writeWithFrom(areaExtendVo, req.getFloorAreaExtendVo());
                floorAreaExtendDao.create(areaExtendVo);
            } else {
                ObjectHelper.writeWithFrom(loadExtend, req.getFloorAreaExtendVo());
                floorAreaExtendDao.update(loadExtend);
            }
            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(req.getAreaId());
            imageService.remove(imageReqVo);

            imageReqVo.setImageList(req.getImageVoList());
            imageService.saveList(imageReqVo);
            return req.getFloorId();
        }
    }

    @Override
    public String areaRemove(FloorAreaReqVo req) {
        FloorAreaVo areaVo = new FloorAreaVo();
        areaVo.setAreaId(req.getAreaId());
        floorAreaDao.remove(areaVo);
        //扩展删除
        FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
        areaExtendVo.setAreaId(req.getAreaId());
        floorAreaExtendDao.remove(areaExtendVo);
        //关联图片删除
        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getAreaId());
        imageService.remove(imageReqVo);
        return req.getAreaId();
    }

    @Override
    public FloorHomeLoadResVo loadCenter(FloorReqVo req) {
        FloorHomeLoadResVo floorHomeLoadResVo = new FloorHomeLoadResVo();
        //内容加载
        CarouselReqVo carouselReqVo = new CarouselReqVo();
        carouselReqVo.setCarouselType(CommonConstant.CAROUSEL_TYPE_CENTER_DISPLAY);
        Integer languageType = req.getLanguageType() == null ? 0 : req.getLanguageType();
        carouselReqVo.setLanguageType(languageType);
        CarouselResVo carouselVo = carouselService.load(carouselReqVo);
        floorHomeLoadResVo.setCarouselVo(carouselVo);
        //楼层加载
        List<FloorResVo> floorList = floorDao.loadBySort(req);
        //特殊区加载
        FloorAreaReqVo areaReqVo = new FloorAreaReqVo();
        areaReqVo.setIsFeature(req.getIsFeature());
        areaReqVo.setAreaStatus(req.getAreaStatus());
        areaReqVo.setLanguageType(languageType);
        List<FloorAreaResVo> floorAreaList = floorAreaDao.loadBySort(areaReqVo);

        floorHomeLoadResVo.setFloorList(floorList);
        floorHomeLoadResVo.setFloorAreaList(floorAreaList);
        return floorHomeLoadResVo;
    }

    @Override
    public PageSizeData<FloorAreaResVo> areaLoadPage(FloorAreaLoadPageReqVo req) {
        PageSizeData<FloorAreaResVo> page = floorAreaDao.loadByPage(req);
        for (FloorAreaResVo floorAreaResVo : page.getList()) {
            FloorAreaExtendVo areaExtendVo = new FloorAreaExtendVo();
            areaExtendVo.setAreaId(floorAreaResVo.getAreaId());
            areaExtendVo.setLanguageType(req.getLanguageType() == null ? CommonConstant.LANGUAGE_TYPE_CHINESE : req.getLanguageType());
            floorAreaResVo.setAreaExtendVo(floorAreaExtendDao.load(areaExtendVo, FloorAreaExtendVo.class));
        }
        return page;
    }

    @Override
    public String floorChangeStatus(FloorReqVo req) {
        FloorVo floorVo = new FloorVo();
        floorVo.setFloorId(req.getFloorId());
        FloorVo load = floorDao.load(floorVo, FloorVo.class);
        load.setFloorStatus(req.getFloorStatus());
        floorDao.update(load);
        return req.getFloorId();
    }

    @Override
    public String areaChangeStatus(FloorAreaReqVo req) {
        FloorAreaVo areaVo = new FloorAreaVo();
        areaVo.setAreaId(req.getAreaId());
        FloorAreaVo load = floorAreaDao.load(areaVo, FloorAreaVo.class);
        load.setAreaStatus(req.getAreaStatus());
        floorAreaDao.update(load);
        return req.getAreaId();
    }
}
