package com.tcm.common.service.impl;

import com.tcm.common.dao.CarouselDao;
import com.tcm.common.dao.CarouselExtendDao;
import com.tcm.common.service.CarouselService;
import com.tcm.common.service.ImageService;
import com.tcm.util.common.CarouselExtendVo;
import com.tcm.util.common.CarouselVo;
import com.tcm.util.common.req.CarouselLoadPageReqVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.tcm.util.common.res.ImageResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class CarouselServiceImpl implements CarouselService {

    private final CarouselDao carouselDao;
    private final ImageService imageService;
    private final CarouselExtendDao carouselExtendDao;

    public CarouselServiceImpl(CarouselDao carouselDao,
                               ImageService imageService,
                               CarouselExtendDao carouselExtendDao) {
        this.carouselDao = carouselDao;
        this.imageService = imageService;
        this.carouselExtendDao = carouselExtendDao;
    }

    @Override
    public CarouselResVo load(CarouselReqVo req) {
        CarouselResVo load = carouselDao.loadInfo(req);
        if (load != null) {
            CarouselExtendVo carouselExtend = new CarouselExtendVo();
            carouselExtend.setCarouselId(load.getCarouselId());
            carouselExtend.setLanguageType(req.getLanguageType());
            load.setCarouselExtendVo(carouselExtendDao.load(carouselExtend, CarouselExtendVo.class));

            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(load.getCarouselId());
            load.setImageList(imageService.loadList(imageReqVo));
        }
        return load;
    }

    @Override
    public String save(CarouselReqVo req) {
        if (StringHelper.isEmpty(req.getCarouselId())) {
            CarouselVo carousel = new CarouselVo();
            String carouselId = StringHelper.getNewID();
            ObjectHelper.writeWithFrom(carousel, req);
            carousel.setCarouselId(carouselId);
            carousel.setPushTime(DateHelper.getNow());
            carousel.setCreateTime(DateHelper.getNow());
            carouselDao.create(carousel);

            CarouselExtendVo carouselExtend = new CarouselExtendVo();
            carouselExtend.setCarouselId(carouselId);
            carouselExtend.setCarouselExtendId(StringHelper.getNewID());
            ObjectHelper.writeWithFrom(carouselExtend, req.getCarouselExtendVo());
            carouselExtendDao.create(carouselExtend);

            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(carouselId);
            imageReqVo.setImageList(req.getImageList());
            imageService.saveList(imageReqVo);

            return carouselId;
        } else {
            CarouselVo carousel = new CarouselVo();
            carousel.setCarouselId(req.getCarouselId());
            CarouselVo load = carouselDao.load(carousel, CarouselVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            carouselDao.update(load);

            CarouselExtendVo carouselExtend = new CarouselExtendVo();
            carouselExtend.setCarouselId(req.getCarouselId());
            carouselExtend.setLanguageType(req.getCarouselExtendVo().getLanguageType());
            CarouselExtendVo loadExtend = carouselExtendDao.load(carouselExtend, CarouselExtendVo.class);
            if (StringHelper.isEmpty(loadExtend)) {
                //新增
                carouselExtend.setCarouselExtendId(StringHelper.getNewID());
                ObjectHelper.writeWithFrom(carouselExtend, req.getCarouselExtendVo());
                carouselExtendDao.create(carouselExtend);
            } else {
                ObjectHelper.writeWithFrom(loadExtend, req.getCarouselExtendVo());
                carouselExtendDao.update(loadExtend);
            }
            //删除老数据
            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(req.getCarouselId());
            imageService.remove(imageReqVo);

            //保存图片
            imageReqVo.setImageList(req.getImageList());
            imageService.saveList(imageReqVo);

            return req.getCarouselId();
        }
    }

    @Override
    public PageSizeData<CarouselResVo> loadPage(CarouselLoadPageReqVo req) {
        PageSizeData<CarouselResVo> page = carouselDao.loadByPage(req);
        CarouselExtendVo carouselExtend = new CarouselExtendVo();
        for (CarouselResVo carouselResVo : page.getList()) {
            carouselExtend.setCarouselId(carouselResVo.getCarouselId());
            carouselExtend.setLanguageType(req.getLanguageType());
            carouselResVo.setCarouselExtendVo(carouselExtendDao.load(carouselExtend, CarouselExtendVo.class));
        }
        return page;
    }

    @Override
    public String remove(CarouselReqVo req) {
        CarouselVo carousel = new CarouselVo();
        carousel.setCarouselId(req.getCarouselId());
        carouselDao.remove(carousel);

        CarouselExtendVo carouselExtend = new CarouselExtendVo();
        carouselExtend.setCarouselId(req.getCarouselId());
        carouselExtendDao.remove(carouselExtend);

        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getCarouselId());
        imageService.remove(imageReqVo);
        return req.getCarouselId();
    }


    @Override
    public String changeStatus(CarouselReqVo req) {
        CarouselVo carousel = new CarouselVo();
        carousel.setCarouselId(req.getCarouselId());
        CarouselVo load = carouselDao.load(carousel, CarouselVo.class);
        load.setCarouselStatus(req.getCarouselStatus());
        carouselDao.update(load);
        return req.getCarouselId();
    }
}
