package com.tcm.util.doctor;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_doctor")
public class DoctorVo {

    /**
     * 医生主键id
     */
    @TableAnnotation("doctor_id")
    @ApiModelProperty(notes = "医生主键id")
    private String doctorId;
    /**
     * 用户id
     */
    @TableAnnotation("user_id")
    @ApiModelProperty(notes = "用户id")
    private String userId;
    /**
     * 医生职称
     */
    @TableAnnotation("title")
    @ApiModelProperty(notes = "医生职称")
    private String title;
    /**
     * 头像
     */
    @TableAnnotation("avatar")
    @ApiModelProperty(notes = "头像")
    private String avatar;
    /**
     * 医生介绍
     */
    @TableAnnotation("introduction")
    @ApiModelProperty(notes = "医生介绍")
    private String introduction;
    /**
     * 状态0启用1休假2禁用
     */
    @TableAnnotation("status")
    @ApiModelProperty(notes = "状态0启用1休假2禁用")
    private Integer status;
    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public DoctorVo() {
    }

    public String getDoctorId() {
        return doctorId;
    }

    public void setDoctorId(String doctorId) {
        this.doctorId = doctorId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
