package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CapitalFlowDao;
import com.pangding.web.vo.order.pd.CapitalFlowVo;
import com.pangding.web.vo.order.req.CapitalFlowReqVo;
import com.pangding.web.vo.order.res.CapitalFlowResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class CapitalFlowDaoImpl extends BaseDaoImpl implements CapitalFlowDao {

    private static final String QUERY_LIST = "QUERY_CAPITAL_FLOW_LIST";

    private static final String QUERY_LIST_TOTAL = "QUERY_LIST_TOTAL";

    @Override
    protected void init() {
        register(CapitalFlowVo.class);
        table.add(QUERY_LIST, "SELECT * FROM pd_capital_flow  where  1=1 {WHERE} order by time desc")
                .add("companyId","and company_id = ? ")
                .add("companyName","and company_name LIKE concat(?,'%') ")
                .add("startDate", "and time >= ? ")
                .add("endDate", "and time <= ? ")
                .add("orderId", "and order_id = ? ")
                .add("category", "and category = ?");

        table.add(QUERY_LIST_TOTAL, "SELECT sum(order_money) as order_money,sum(order_fee) as order_fee,sum(actual_money) as actual_money " +
                "FROM pd_capital_flow  where  1=1 {WHERE} order by time desc")
                .add("companyId","and company_id = ? ")
                .add("companyName","and company_name LIKE concat(?,'%')")
                .add("startDate", "and time >= ? ")
                .add("endDate", "and time <= ? ")
                .add("orderId", "and order_id = ? ")
                .add("category", "and category = ?");
    }

    @Override
    public PageSizeData<CapitalFlowResVo> findCapitalFlowList(CapitalFlowReqVo req){
        return this.queryPage(CapitalFlowResVo.class, req, QUERY_LIST, req);
    }

    @Override
    public CapitalFlowResVo findCapitalFlowTotal(CapitalFlowReqVo req){
        return this.queryFirst(CapitalFlowResVo.class, QUERY_LIST_TOTAL, req);
    }
}
