package com.pangding.web.authority.dao;

import com.pangding.web.authority.vo.reqvo.ListRoleReqVo;
import com.pangding.web.authority.vo.reqvo.RoleGetReqVo;
import com.pangding.web.authority.vo.RoleVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @author zhangjinyao
 */
public interface RoleDao extends BaseDao {

    /**
     * 通过主键id获取RoleVo对象
     *
     * @param roleGetReqVo getRoleByRoleIdReqVo对象
     * @return  RoleVo对象
     */
    RoleVo getRoleById(RoleGetReqVo roleGetReqVo);

    /**
     * 通过角色名查询RoleVo对象
     *
     * @param getRoleByRoleNameReqVo 角色名
     * @return RoleVo对象
     */
    RoleVo getRoleByRoleName(RoleGetReqVo getRoleByRoleNameReqVo);

    /**
     * 检查用户名是否已存在
     * 若返回数据大于0，则已存在，该用户名不可用
     * 为0则可用
     *
     * @param roleVo 需要检查的RoleVo对象
     * @return RoleVo对象的用户名在数据库中是否使用过
     */
    void checkNameExist(RoleVo roleVo);

    /**
     * 获取角色分页对象
     *
     * @param req
     * @return 角色分页对象
     */
    PageSizeData<RoleVo> getRoleVoList(ListRoleReqVo req);

    /**
     * 通过角色id获取子角色列表
     *
     * @param roleGetReqVo 封装角色id
     * @return 角色列表
     */
    List<RoleVo> getChild(RoleGetReqVo roleGetReqVo);

}
