package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.*;
import com.pangding.web.authority.service.CompanyService;
import com.pangding.web.authority.service.PangdingPartnerService;
import com.pangding.web.authority.service.UserService;
import com.pangding.web.authority.util.CompanyBankCardConstant;
import com.pangding.web.authority.util.ShareCodeUtil;
import com.pangding.web.authority.vo.*;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.*;
import com.pangding.web.vo.system.pd.authority.UserVo;
import com.pangding.web.vo.system.pd.company.CompanyBankCardVo;
import com.pangding.web.vo.system.pd.company.CompanyExtendVo;
import com.pangding.web.vo.system.pd.company.CompanyVo;
import com.pangding.web.vo.system.req.company.CompanyBankCardReqVo;
import com.yanzuoguang.util.exception.CodeException;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author zhangjinyao
 * @create 2019/6/19 16:49
 */
@Service
public class PangdingPartnerServiceImpl implements PangdingPartnerService {
    @Autowired
    private CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    private CompanyBankCardDao companyBankCardDaoImpl;
    @Autowired
    private CompanyService companyServiceImpl;
    @Autowired
    private UserDao userDaoImpl;
    @Autowired
    private CompanyDao companyDaoImpl;
    @Autowired
    private WechatUserDao wechatUserDaoImpl;

    /**
     * 胖丁伙伴首页
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public HomeResVo home(HomeReqVo reqVo) {
        /*通过公司id到公司扩展表查询可提现余额*/
        CompanyExtendGetReqVo getReqVo = new CompanyExtendGetReqVo();
        getReqVo.setId(reqVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(getReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo){
            throw new CodeException("未查到该公司数据");
        }
        /*返回对象*/
        HomeResVo resVo = new HomeResVo();
        resVo.setCompanyId(reqVo.getCompanyId());
        resVo.setWithdrawTotalCash(companyExtendVo.getWithdrawTotalCash());
        return resVo;
    }

    /**
     * 通过公司id获取该公司的可提现余额以及默认提现银行卡
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public MobileWithdrawalResVo withdrawal(MobileWithdrawalReqVo reqVo) {
        MobileWithdrawalResVo resVo = new MobileWithdrawalResVo();
        resVo.setCompanyId(reqVo.getCompanyId());
        resVo.setWithdrawTotalCash(reqVo.getWithdrawTotalCash());
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(reqVo.getCompanyId());
        getReqVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(getReqVo,CompanyBankCardVo.class);
        if (null == companyBankCardVo){
            throw new CodeException("该公司暂无默认提现银行卡");
        }
        resVo.setCompanyBankCardVo(companyBankCardVo);
        return resVo;
    }

    /**
     * 通过公司id获取该公司银行卡列表（不分页）
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public List<CompanyBankCardVo> bankCardList(MobileBankCardListReqVo reqVo) {
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(reqVo.getCompanyId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(getReqVo,CompanyBankCardVo.class);
        if (null == companyBankCardVoList || companyBankCardVoList.isEmpty()){
            throw new CodeException("该公司暂无银行卡");
        }
//        Collections.sort(companyBankCardVoList);
        return companyBankCardVoList;
    }

    /**
     * 保存/更新银行卡信息，并调用第三方接口发送手机验证码
     * @param reqVo 公司银行卡表信息
     * @return 银行卡表主键
     */
    @Override
    public ResponseResult<CompanyBankCardVo> saveBank(CompanyBankCardReqVo reqVo) {
        return companyServiceImpl.saveBank(reqVo);
    }

    /**
     * 提交银行卡信息，验证手机验证码，并更新银行卡状态
     * @param reqVo 银行卡表数据+验证码
     * @return 目前返回验证码
     */
    @Override
    public CompanyBankCardVo bankSubmit(BankSubmitReqVo reqVo) {
        return companyServiceImpl.bankSubmit(reqVo);
    }

    /**
     * 调用支付服务解绑银行卡，并更新银行卡状态
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    @Override
    public void deleteBank(CompanyBankCardVo reqVo) {
        companyServiceImpl.deleteBank(reqVo);
    }

    /**
     * 设置该银行卡为默认支付，并取消其他银行卡的默认
     * @param reqVo 封装了银行卡id的请求对象
     * @return
     */
    @Override
    public void setDefault(CompanyBankCardVo reqVo) {
        companyServiceImpl.setDefault(reqVo);
    }

    /**
     * 我的管理页面：通过userId获取用户表，公司表，公司银行卡表数据
     * @param reqVo 封装了userId的请求对象
     * @return
     */
    @Override
    public ManagementResVo management(ManagementReqVo reqVo) {
        /*返回对象*/
        ManagementResVo resVo = new ManagementResVo();
        /*用户对象*/
        UserGetReqVo userGetReqVo = new UserGetReqVo();
        userGetReqVo.setId(reqVo.getUserId());
        UserVo userVo = userDaoImpl.load(userGetReqVo,UserVo.class);
        if (null == userVo){
            throw new CodeException("未查询到该用户信息");
        }
        resVo.setUserVo(userVo);
        /*公司表对象*/
        CompanyGetReqVo companyGetReqVo = new CompanyGetReqVo();
        companyGetReqVo.setId(userVo.getCompanyId());
        CompanyVo companyVo = companyDaoImpl.load(companyGetReqVo,CompanyVo.class);
        if (null == companyVo){
            throw new CodeException("未查询到该用户公司信息");
        }
        resVo.setCompanyVo(companyVo);
        /*默认银行卡对象*/
        CompanyBankCardGetReqVo companyBankCardGetReqVo = new CompanyBankCardGetReqVo();
        companyBankCardGetReqVo.setCompanyId(userVo.getCompanyId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(companyBankCardGetReqVo,CompanyBankCardVo.class);

        if (null != companyBankCardVoList && !companyBankCardVoList.isEmpty()){
//            Collections.sort(companyBankCardVoList);
            resVo.setCompanyBankCardVoList(companyBankCardVoList);
        }
        return resVo;
    }

    /**
     * 根据公司id获取该公司今日用户沉淀量，总沉淀量，沉淀用户列表
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public PrecipitationResVo precipitation(PrecipitationReqVo reqVo) {
        /*返回对象*/
        PrecipitationResVo resVo = new PrecipitationResVo();
        resVo.setCompanyId(reqVo.getCompanyId());
        /*今日沉淀量*/
        WechatUserGetReqVo todayGetReqVo = new WechatUserGetReqVo();
        todayGetReqVo.setSourceCompanyId(reqVo.getCompanyId());
        todayGetReqVo.setStart(DateHelper.getNow().substring(0,10)+" 00:00:00");
        todayGetReqVo.setEnd(DateHelper.getNow().substring(0,10)+" 23:59:59");
        List<Map> todayList = (List<Map>) wechatUserDaoImpl.getUserNum(todayGetReqVo);
        Long today = (Long) todayList.get(0).get("num");
        resVo.setTodayPrecipitation(today);
        /*总沉淀量*/
        WechatUserGetReqVo totalGetReqVo = new WechatUserGetReqVo();
        totalGetReqVo.setSourceCompanyId(reqVo.getCompanyId());
        List<Map> totalList = (List<Map>) wechatUserDaoImpl.getUserNum(totalGetReqVo);
        Long total = (Long) totalList.get(0).get("num");
        resVo.setTotalPrecipitation(total);
        /*沉淀用户分页列表*/
        WechatUserGetReqVo userListGetReqVo = new WechatUserGetReqVo();
        userListGetReqVo.setSourceCompanyId(reqVo.getCompanyId());
        PageSizeData<WechatUserVo> wechatUserVoList = wechatUserDaoImpl.getUserList(userListGetReqVo);
        resVo.setWechatUserVoList(wechatUserVoList);
        return resVo;
    }

    /**
     * 根据公司id返回该公司二维码url，若没有则创建
     * @param reqVo 封装了公司id和选项（限制为永久）的请求对象
     * @return
     */
    @Override
    public String qrCodeUrl(GenerateQrCodeUrlReqVo reqVo) {
        return companyServiceImpl.generateQrCodeUrl(reqVo);
    }

    /**
     * 根据公司id获取该公司的邀请码，若没有则创建
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String invitation(InvitationReqVo reqVo) {

        /*邀请码*/
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(reqVo.getCompanyId(),CompanyExtendVo.class);
        if (null == companyExtendVo){
            companyExtendVo.setId(reqVo.getCompanyId());
            companyExtendVo.setQrCode(DateHelper.getNow()
                    .replace("-","")
                    .replace(":","")
                    .replace(" ",""));
            companyExtendDaoImpl.create(companyExtendVo);
        }
        String invitationCode = companyExtendVo.getInvitationCode();
        if (StringHelper.isEmpty(invitationCode)){
            invitationCode = ShareCodeUtil.toSerialCode((new Date()).getTime());
            companyExtendVo.setInvitationCode(invitationCode);
            companyExtendDaoImpl.update(companyExtendVo);
        }

        return invitationCode;
    }

    /**
     * 邀请商家列表
     * @param reqVo
     * @return
     */
    @Override
    public InviteMembersResVo inviteMembers(InviteMembersReqVo reqVo) {
        InviteMembersResVo resVo = new InviteMembersResVo();
        PageSizeData<CompanyVo> companyVoPageSizeData = companyDaoImpl.loadPage(reqVo,CompanyVo.class);
        resVo.setCompanyVoPageSizeData(companyVoPageSizeData);
        return resVo;
    }
}
