package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.PangdingPartnerService;
import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.HomeResVo;
import com.pangding.web.authority.vo.resvo.MobileWithdrawalResVo;
import com.pangding.web.authority.vo.resvo.WithdrawalResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/19 15:26
 */
@RestController
@RequestMapping(value = "/partner")
public class PangdingPartnerController {
    @Autowired
    PangdingPartnerService pangdingPartnerServiceImpl;

    /**
     * 胖丁伙伴首页
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @PostMapping(value = "/home",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<HomeResVo> home(@RequestBody HomeReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(pangdingPartnerServiceImpl.home(reqVo));
    }

    /**
     * 通过公司id获取该公司的可提现余额以及默认提现银行卡
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @PostMapping(value = "/withdrawal",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<MobileWithdrawalResVo> withdrawal(@RequestBody MobileWithdrawalReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .notBlankCheck("withdrawTotalCash",reqVo.getWithdrawTotalCash())
                .checkException();
        return ResponseResult.result(pangdingPartnerServiceImpl.withdrawal(reqVo));
    }

    @PostMapping(value = "/bankCardList",produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseResult<List<CompanyBankCardVo>> bankCardList(@RequestBody MobileBankCardListReqVo reqVo){
        CheckerHelper.newInstance()
                .notBlankCheck("companyId",reqVo.getCompanyId())
                .checkException();
        return ResponseResult.result(pangdingPartnerServiceImpl.bankCardList(reqVo));
    }
}
