package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.CompanyBankCardDao;
import com.pangding.web.authority.dao.CompanyExtendDao;
import com.pangding.web.authority.service.PangdingPartnerService;
import com.pangding.web.authority.util.CompanyBankCardConstant;
import com.pangding.web.authority.vo.CompanyBankCardVo;
import com.pangding.web.authority.vo.CompanyExtendVo;
import com.pangding.web.authority.vo.reqvo.*;
import com.pangding.web.authority.vo.resvo.HomeResVo;
import com.pangding.web.authority.vo.resvo.MobileWithdrawalResVo;
import com.yanzuoguang.util.exception.CodeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/6/19 16:49
 */
@Service
public class PangdingPartnerServiceImpl implements PangdingPartnerService {
    @Autowired
    CompanyExtendDao companyExtendDaoImpl;
    @Autowired
    CompanyBankCardDao companyBankCardDaoImpl;

    /**
     * 胖丁伙伴首页
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public HomeResVo home(HomeReqVo reqVo) {
        /*通过公司id到公司扩展表查询可提现余额*/
        CompanyExtendGetReqVo getReqVo = new CompanyExtendGetReqVo();
        getReqVo.setId(reqVo.getCompanyId());
        CompanyExtendVo companyExtendVo = companyExtendDaoImpl.load(getReqVo,CompanyExtendVo.class);
        if (null == companyExtendVo){
            throw new CodeException("未查到该公司数据");
        }
        /*返回对象*/
        HomeResVo resVo = new HomeResVo();
        resVo.setWithdrawTotalCash(companyExtendVo.getWithdrawTotalCash());
        return resVo;
    }

    /**
     * 通过公司id获取该公司的可提现余额以及默认提现银行卡
     * @param reqVo 封装了公司id的请求对象
     * @return
     */
    @Override
    public MobileWithdrawalResVo withdrawal(MobileWithdrawalReqVo reqVo) {
        MobileWithdrawalResVo resVo = new MobileWithdrawalResVo();
        resVo.setCompanyId(reqVo.getCompanyId());
        resVo.setWithdrawTotalCash(reqVo.getWithdrawTotalCash());
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(reqVo.getCompanyId());
        getReqVo.setIsDefault(CompanyBankCardConstant.IS_DEFAULT);
        CompanyBankCardVo companyBankCardVo = companyBankCardDaoImpl.load(getReqVo,CompanyBankCardVo.class);
        if (null == companyBankCardVo){
            throw new CodeException("该公司暂无默认提现银行卡");
        }
        resVo.setCompanyBankCardVo(companyBankCardVo);
        return resVo;
    }

    @Override
    public List<CompanyBankCardVo> bankCardList(MobileBankCardListReqVo reqVo) {
        CompanyBankCardGetReqVo getReqVo = new CompanyBankCardGetReqVo();
        getReqVo.setCompanyId(reqVo.getCompanyId());
        List<CompanyBankCardVo> companyBankCardVoList = companyBankCardDaoImpl.loadList(getReqVo,CompanyBankCardVo.class);
        if (null == companyBankCardVoList || companyBankCardVoList.isEmpty()){
            throw new CodeException("该公司暂无银行卡");
        }
        Collections.sort(companyBankCardVoList);
        return companyBankCardVoList;
    }
}
