package com.pangding.web.authority.dao.company;

import com.pangding.web.vo.system.req.company.CompanyReqVo;
import com.pangding.web.vo.system.res.company.CompanyNumberResVo;
import com.pangding.web.vo.system.res.company.CompanyResVo;
import com.yanzuoguang.dao.BaseDao;
import com.yanzuoguang.util.vo.PageSizeData;

import java.util.List;

/**
 * @Author zhangjinyao
 * @create 2019/5/13 14:24
 */
public interface CompanyDao extends BaseDao {

    /**
     * 获取公司列表分页对象
     * @param reqVo
     * @return
     */
    PageSizeData<CompanyResVo> findCompanyListPage(CompanyReqVo reqVo);

    /**
     * 获取公司列表
     * @param req
     * @return
     */
    List<CompanyResVo> findCompanyList(CompanyReqVo req);

    /**
     * 找到公司详情
     * @param req
     * @return
     */
    CompanyResVo findCompany(CompanyReqVo req);

    /**
     * 获取公司总数
     * @param req
     * @return
     */
    CompanyNumberResVo findCompanyTotal(CompanyReqVo req);
}
