package com.pangding.web.system.dao.impl;

import com.pangding.web.system.dao.SystemWarnDao;
import com.pangding.web.vo.system.pd.SystemWarnVo;
import com.pangding.web.vo.system.req.SystemWarnPageReqVo;
import com.pangding.web.vo.system.res.SystemWarnResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class SystemWarnDaoImpl extends BaseDaoImpl implements SystemWarnDao {

    private final String QUERY_LIST = "QUERY_LIST";


    @Override
    protected void init() {
        register(SystemWarnVo.class);

        table.add(QUERY_LIST, " select * from pd_system_warning where 1=1 {WHERE}")
                .add("startDate"," and create_date >= ? ")
                .add("endDate"," and create_date <= ? ")
                .add("systemWarningId"," and system_warning_id = ? ")
                .add("warnType"," and warn_type = ? ")
                .add("warnName"," and warnName LIKE concat('%', ?,'%') ")
                .add("companyName"," and companyName LIKE concat('%', ?,'%')  ")
                .add("merchantName"," and merchantName LIKE concat('%', ?,'%')  ")
                .add("productName"," and productName LIKE concat('%', ?,'%')  ")
                .add("channelTypeList"," and channelTypeList in ( ? ) ")
                .add("warnStatusList"," and warnStatusList in ( ? ) ");

    }

    public PageSizeData<SystemWarnResVo> findListPage(SystemWarnPageReqVo req){
        return this.queryPage(SystemWarnResVo.class, req, QUERY_LIST, req);

    }
}
