package com.pangding.web.system.service.impl;

import com.pangding.web.system.dao.SystemWarnDao;
import com.pangding.web.system.service.SystemWarnService;
import com.pangding.web.vo.system.pd.SystemWarnVo;
import com.pangding.web.vo.system.req.SystemWarnPageReqVo;
import com.pangding.web.vo.system.req.SystemWarnReqVo;
import com.pangding.web.vo.system.res.SystemWarnResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class SystemWarnServiceImpl implements SystemWarnService {

    private SystemWarnDao systemWarnDao;

    public SystemWarnServiceImpl(SystemWarnDao systemWarnDao) {
        this.systemWarnDao = systemWarnDao;
    }

    public PageSizeData<SystemWarnResVo> findListPage(SystemWarnPageReqVo req){
        return systemWarnDao.findListPage(req);
    }

    public SystemWarnResVo find(SystemWarnReqVo req){
        return systemWarnDao.load(req, SystemWarnResVo.class);
    }

    public void save(SystemWarnReqVo req){
        SystemWarnReqVo sqlReq = new SystemWarnReqVo();
        sqlReq.setCompanyName(req.getCompanyName());
        sqlReq.setMerchantName(req.getMerchantName());
        sqlReq.setProductName(req.getProductName());
        sqlReq.setWarnName(req.getWarnName());
        sqlReq.setWarnType(req.getWarnType());
        sqlReq.setChannelType(req.getChannelType());
        SystemWarnResVo systemWarnResVo = systemWarnDao.load(sqlReq, SystemWarnResVo.class);
        if(StringHelper.isEmpty(systemWarnResVo)){
            SystemWarnVo systemWarnVo = new SystemWarnVo();
            ObjectHelper.writeWithFromClass(systemWarnVo, req);
            systemWarnDao.create(systemWarnVo);
        }else{
            ObjectHelper.writeWithFromClass(systemWarnResVo, req);
            systemWarnDao.update(systemWarnResVo);
        }
    }

}
