package com.pangding.web.authority.controller;

import com.pangding.web.authority.service.CompanyCodeService;
import com.pangding.web.vo.system.req.company.CompanyCodeReqVo;
import com.pangding.web.vo.system.res.company.CompanyCodeResVo;
import com.yanzuoguang.util.helper.CheckerHelper;
import com.yanzuoguang.util.vo.ResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/companyCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "商户二维码相关类", description = "商户二维码新增，修改，删除等相关操作")
public class CompanyCodeController {

    @Autowired
    private CompanyCodeService companyCodeService;

    @RequestMapping(value = "/findCodeLink")
    @ApiOperation(value = "查询商户跳转链接地址", notes = "返回商户需要跳转的连接地址.")
    public ResponseResult<CompanyCodeResVo> findCodeLink(@RequestBody CompanyCodeReqVo req) {
        CheckerHelper.newInstance().notBlankCheck("companyId", req.getCompanyId())
                .notBlankCheck("codeType", req.getCodeType())
                .checkException();
        return ResponseResult.result(companyCodeService.findCodeLink(req));
    }

    @RequestMapping(value = "/findCodeList")
    @ApiOperation(value = "查询商户二维码列表", notes = "返回商户二维码列表")
    public ResponseResult findCodeList(@RequestBody CompanyCodeReqVo req) {
        return null;
    }


}
