package com.pangding.web.authority.service.impl;

import com.pangding.web.authority.dao.DeviceDao;
import com.pangding.web.authority.service.DeviceService;
import com.pangding.web.vo.system.pd.device.DeviceVo;
import com.pangding.web.vo.system.req.DeviceReqVo;
import com.pangding.web.vo.system.res.DeviceResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceServiceImpl implements DeviceService {

    @Autowired
    private DeviceDao deviceDao;

    @Override
    public ResponseResult<PageSizeData<DeviceResVo>> findDeviceList(DeviceReqVo req) {
        PageSizeData<DeviceResVo> deviceResVoPageSizeData = deviceDao.findDevicePage(req);
        return ResponseResult.result(deviceResVoPageSizeData);
    }

    @Override
    public ResponseResult<DeviceResVo> findDeviceInfo(DeviceReqVo req) {
        DeviceResVo deviceResVo = deviceDao.load(req.getDeviceId(), DeviceResVo.class);
        return ResponseResult.result(deviceResVo);
    }

    @Override
    public ResponseResult saveDevice(DeviceReqVo req) {
        return ResponseResult.result(null);
    }

    @Override
    public ResponseResult<DeviceVo> updateDevice(DeviceReqVo req) {
        DeviceVo deviceVo = deviceDao.load(req.getDeviceId(), DeviceVo.class);
        if(StringHelper.isEmpty(deviceVo)){
            return ResponseResult.error("99", "设备编号有误");
        }
        ObjectHelper.writeWithFrom(deviceVo, req);
        deviceDao.update(deviceVo);
        return ResponseResult.result(deviceVo);
    }

    @Override
    public ResponseResult delDevice(DeviceReqVo req) {
        deviceDao.remove(req);
        return ResponseResult.result(null);
    }
}
