package com.tcm.common.dao.impl;

import com.tcm.common.dao.CenterDisplayDao;
import com.tcm.util.area.CenterDisplayVo;
import com.tcm.util.area.res.CenterDisplayResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CenterDisplayDaoImpl extends BaseDaoImpl implements CenterDisplayDao {

    private static final String SQL_LOAD_BY_LIST = "LOAD_BY_LIST";

    @Override
    protected void init() {
        register(CenterDisplayVo.class);
        table.add(SQL_LOAD_BY_LIST, "select p.*,pi.image_url as iconUrl from tcm_center_display as p " +
                "left join tcm_image as pi on p.display_id on pi.relation_id  where 1=1 {WHERE} order by p.sort")
                .add("displayId", "p.display_id = ?")
                .add("title", "p.title = ?")
        ;
    }

    @Override
    public List<CenterDisplayResVo> loadByList(CenterDisplayVo req) {
        return this.query(CenterDisplayResVo.class, SQL_LOAD_BY_LIST, req);
    }
}
