package com.tcm.common.service.impl;

import com.tcm.common.dao.FloorAreaDao;
import com.tcm.common.dao.FloorDao;
import com.tcm.common.service.AreaService;
import com.tcm.common.service.CarouselService;
import com.tcm.common.service.ImageService;
import com.tcm.common.util.CommonConstant;
import com.tcm.util.area.FloorAreaVo;
import com.tcm.util.area.FloorVo;
import com.tcm.util.area.req.FloorAreaReqVo;
import com.tcm.util.area.req.FloorLoadPageReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.tcm.util.area.res.FloorHomeLoadResVo;
import com.tcm.util.area.res.FloorResVo;
import com.tcm.util.common.CarouselVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.tcm.util.common.res.ImageResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class AreaServiceImpl implements AreaService {

    private final FloorDao floorDao;
    private final FloorAreaDao floorAreaDao;
    private final ImageService imageService;
    private final CarouselService carouselService;

    public AreaServiceImpl(FloorDao floorDao,
                           FloorAreaDao floorAreaDao,
                           ImageService imageService,
                           CarouselService carouselService) {
        this.floorDao = floorDao;
        this.floorAreaDao = floorAreaDao;
        this.imageService = imageService;
        this.carouselService = carouselService;
    }

    @Override
    public String floorSave(FloorReqVo req) {
        if (StringHelper.isEmpty(req.getFloorId())) {
            FloorVo floor = new FloorVo();
            String floorId = StringHelper.getNewID();
            floor.setFloorId(floorId);
            ObjectHelper.writeWithFrom(floor, req);
            floor.setCreateTime(DateHelper.getNow());
            floorDao.save(floor);
            return floorId;
        } else {
            FloorVo floor = new FloorVo();
            floor.setFloorId(req.getFloorId());
            FloorVo load = floorDao.load(floor, FloorVo.class);
            ObjectHelper.writeWithFrom(load, req);
            floorDao.update(load);
            return req.getFloorId();
        }
    }

    @Override
    public FloorResVo floorLoad(FloorReqVo req) {
        FloorVo floor = new FloorVo();
        floor.setFloorId(req.getFloorId());
        FloorResVo load = floorDao.load(floor, FloorResVo.class);
        return load;
    }

    @Override
    public PageSizeData<FloorResVo> loadPage(FloorLoadPageReqVo req) {
        PageSizeData<FloorResVo> page = floorDao.loadPage(req, FloorResVo.class);
        return page;
    }

    @Override
    public String floorRemove(FloorReqVo req) {
        //楼层删除
        FloorVo floor = new FloorVo();
        floor.setFloorId(req.getFloorId());
        floorDao.remove(floor);
        //楼层图片删除
        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getFloorId());
        imageService.remove(imageReqVo);

        //区域删除
        FloorAreaVo areaVo = new FloorAreaVo();
        areaVo.setFloorId(req.getFloorId());
        List<FloorAreaVo> areaList = floorAreaDao.loadList(areaVo, FloorAreaVo.class);
        floorAreaDao.remove(areaVo);
        //区域图片删除
        for (FloorAreaVo floorAreaVo : areaList) {
            ImageReqVo areaImageReqVo = new ImageReqVo();
            areaImageReqVo.setRelationId(floorAreaVo.getAreaId());
            imageService.remove(imageReqVo);
        }
        return req.getFloorId();
    }

    @Override
    public FloorAreaResVo areaLoad(FloorAreaReqVo req) {
        FloorAreaVo areaVo = new FloorAreaVo();
        areaVo.setAreaId(req.getAreaId());
        FloorAreaResVo load = floorAreaDao.load(areaVo, FloorAreaResVo.class);
        ImageReqVo imageReq = new ImageReqVo();
        imageReq.setRelationId(load.getAreaId());
        List<ImageResVo> images = imageService.loadList(imageReq);
        load.setImageList(images);
        return load;
    }

    @Override
    public String areaSave(FloorAreaReqVo req) {
        if (StringHelper.isEmpty(req.getAreaId())) {
            FloorAreaVo areaVo = new FloorAreaVo();
            String areaId = StringHelper.getNewID();
            areaVo.setFloorId(areaId);
            ObjectHelper.writeWithFrom(areaVo, req);
            areaVo.setCreateTime(DateHelper.getNow());
            floorAreaDao.save(areaVo);
            return areaId;
        } else {
            FloorAreaVo areaVo = new FloorAreaVo();
            areaVo.setAreaId(req.getAreaId());
            FloorAreaVo load = floorAreaDao.load(areaVo, FloorAreaVo.class);
            ObjectHelper.writeWithFrom(load, req);
            floorAreaDao.update(load);
            return req.getFloorId();
        }
    }

    @Override
    public String areaRemove(FloorAreaReqVo req) {
        FloorAreaVo areaVo = new FloorAreaVo();
        areaVo.setAreaId(req.getAreaId());
        floorAreaDao.remove(areaVo);
        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getAreaId());
        imageService.remove(imageReqVo);
        return req.getAreaId();
    }

    @Override
    public FloorHomeLoadResVo loadCenter(FloorReqVo req) {
        FloorHomeLoadResVo floorHomeLoadResVo = new FloorHomeLoadResVo();
        //内容加载
        CarouselReqVo carouselReqVo = new CarouselReqVo();
        carouselReqVo.setCarouselType(CommonConstant.CAROUSEL_TYPE_CENTER_DISPLAY);
        CarouselResVo carouselVo = carouselService.load(carouselReqVo);
        floorHomeLoadResVo.setCarouselVo(carouselVo);
        //楼层加载
        List<FloorResVo> floorList = floorDao.loadList(req, FloorResVo.class);
        //特殊区加载
        List<FloorAreaResVo> floorAreaList = new ArrayList<>();
        floorHomeLoadResVo.setFloorList(floorList);
        floorHomeLoadResVo.setFloorAreaList(floorAreaList);
        return floorHomeLoadResVo;
    }
}
