package com.tcm.common.service.impl;

import com.tcm.common.dao.CarouselDao;
import com.tcm.common.service.CarouselService;
import com.tcm.common.service.ImageService;
import com.tcm.util.area.req.CenterDisplayReqVo;
import com.tcm.util.common.CarouselVo;
import com.tcm.util.common.req.CarouselLoadPageReqVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.req.ImageReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Service;

@Service
public class CarouselServiceImpl implements CarouselService {

    private final CarouselDao carouselDao;
    private final ImageService imageService;

    public CarouselServiceImpl(CarouselDao carouselDao, ImageService imageService) {
        this.carouselDao = carouselDao;
        this.imageService = imageService;
    }

    @Override
    public CarouselResVo load(CarouselReqVo carouselReqVo) {
        CarouselResVo load = carouselDao.load(carouselReqVo, CarouselResVo.class);
        if (load != null) {
            ImageReqVo imageReqVo = new ImageReqVo();
            imageReqVo.setRelationId(load.getCarouselId());
            load.setImageList(imageService.loadList(imageReqVo));
        }
        return load;
    }

    @Override
    public String save(CarouselReqVo req) {
        if (StringHelper.isEmpty(req.getCarouselId())) {
            CarouselVo carousel = new CarouselVo();
            String carouselId = StringHelper.getNewID();
            ObjectHelper.writeWithFrom(carousel, req);
            carousel.setCarouselId(carouselId);
            carousel.setCreateTime(DateHelper.getNow());
            carouselDao.save(req);
            return carouselId;
        } else {
            CarouselVo carousel = new CarouselVo();
            carousel.setCarouselId(req.getCarouselId());
            CarouselVo load = carouselDao.load(carousel, CarouselVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            carouselDao.update(carousel);
            return req.getCarouselId();
        }
    }

    @Override
    public PageSizeData<CarouselResVo> loadPage(CarouselLoadPageReqVo req) {
        PageSizeData<CarouselResVo> page = carouselDao.loadPage(req, CarouselResVo.class);
        return page;
    }

    @Override
    public String remove(CarouselReqVo req) {
        CarouselVo carousel = new CarouselVo();
        carousel.setCarouselId(req.getCarouselId());
        carouselDao.remove(carousel);
        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getCarouselId());
        imageService.remove(imageReqVo);
        return req.getCarouselId();
    }
}
