package com.tcm.common.web;

import com.tcm.common.service.CarouselService;
import com.tcm.util.area.req.CenterDisplayReqVo;
import com.tcm.util.area.req.FloorReqVo;
import com.tcm.util.area.res.CenterDisplayResVo;
import com.tcm.util.common.req.CarouselLoadPageReqVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.req.TcmEnumReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/carousel")
public class CarouselController {

    private final CarouselService carouselService;

    public CarouselController(CarouselService carouselService) {
        this.carouselService = carouselService;
    }

    /**
     * 区域新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.save(req));

    }
    /**
     * 展示区加载
     */
    @RequestMapping("/load")
    public ResponseResult<CarouselResVo> load(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.load(req));

    }
    /**
     * 展示区列表
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<CarouselResVo>> loadPage(@RequestBody CarouselLoadPageReqVo req) {
        return ResponseResult.result(carouselService.loadPage(req));

    }

    /**
     * 展示区删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody CarouselReqVo req) {
        return ResponseResult.result(carouselService.remove(req));

    }
}
