package com.tcm.common.web;

import com.tcm.common.service.TcmEnumService;
import com.tcm.util.common.req.TcmEnumLoadPageReqVo;
import com.tcm.util.common.req.TcmEnumReqVo;
import com.tcm.util.common.res.TcmEnumResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/tcmEnum")
public class TcmEnumController {

    private final TcmEnumService tcmEnumService;

    public TcmEnumController(TcmEnumService tcmEnumService) {
        this.tcmEnumService = tcmEnumService;
    }

    /**
     * 枚举新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody TcmEnumReqVo req) {
        return ResponseResult.result(tcmEnumService.save(req));

    }

    /**
     * 枚举加载
     */
    @RequestMapping("/load")
    public ResponseResult<TcmEnumResVo> load(@RequestBody TcmEnumReqVo req) {
        return ResponseResult.result(tcmEnumService.load(req));

    }

    /**
     * 枚举分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<TcmEnumResVo>> loadPage(@RequestBody TcmEnumLoadPageReqVo req) {
        return ResponseResult.result(tcmEnumService.loadPage(req));

    }

    /**
     * 枚举删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody TcmEnumReqVo req) {
        return ResponseResult.result(tcmEnumService.remove(req));

    }
}
