package com.tcm.product.dao.impl;

import com.tcm.product.dao.ProductCategoryDao;
import com.tcm.util.product.ProductCategoryVo;
import com.tcm.util.product.req.ProductCategoryLoadPageReqVo;
import com.tcm.util.product.res.ProductCategoryResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class ProductCategoryDaoImpl extends BaseDaoImpl implements ProductCategoryDao {

    private static final String SQL_LOAD_BY_PAGE = "LOAD_BY_PAGE";

    @Override
    protected void init() {
        register(ProductCategoryVo.class);
        table.add(SQL_LOAD_BY_PAGE, "select p.*,pi.image_url as imageUrl from tcm_product_category as  p where p.category_id " +
                "left join tcm_image as pi on p.category_id = pi.relation_id where 1=1 {WHERE} order by p.sort")

        ;
    }

    @Override
    public PageSizeData<ProductCategoryResVo> loadByPage(ProductCategoryLoadPageReqVo req) {
        return this.queryPage(ProductCategoryResVo.class, req, SQL_LOAD_BY_PAGE, req);
    }
}
