package com.tcm.product.web;

import com.tcm.product.service.ProductCategoryService;
import com.tcm.util.product.req.ProductCategoryLoadPageReqVo;
import com.tcm.util.product.req.ProductCategoryReqVo;
import com.tcm.util.product.res.ProductCategoryResVo;
import com.yanzuoguang.util.vo.PageSizeData;
import com.yanzuoguang.util.vo.ResponseResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品分类管理
 */
@RestController
@RequestMapping("/productCategory")
public class ProductCategoryController {

    private final ProductCategoryService productCategoryService;

    public ProductCategoryController(ProductCategoryService productCategoryService) {
        this.productCategoryService = productCategoryService;
    }


    /**
     * 产品分类新增
     */
    @RequestMapping("/save")
    public ResponseResult<String> save(@RequestBody ProductCategoryReqVo req) {
        return ResponseResult.result(productCategoryService.save(req));

    }

    /**
     * 产品分类加载
     */
    @RequestMapping("/load")
    public ResponseResult<ProductCategoryResVo> load(@RequestBody ProductCategoryReqVo req) {
        return ResponseResult.result(productCategoryService.load(req));

    }
    /**
     * 产品分类分页查询
     */
    @RequestMapping("/loadPage")
    public ResponseResult<PageSizeData<ProductCategoryResVo>> loadPage(@RequestBody ProductCategoryLoadPageReqVo req) {
        return ResponseResult.result(productCategoryService.loadPage(req));

    }
    /**
     * 产品分类删除
     */
    @RequestMapping("/remove")
    public ResponseResult<String> remove(@RequestBody ProductCategoryReqVo req) {
        return ResponseResult.result(productCategoryService.remove(req));

    }
    /**
     * 分类展示产品
     */
    @RequestMapping("/categoryProductPage")
    public ResponseResult<PageSizeData<ProductCategoryResVo>> categoryProductPage(@RequestBody ProductCategoryLoadPageReqVo req) {
        return ResponseResult.result(productCategoryService.categoryProductPage(req));
    }
}
