package com.tcm.util.doctor;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_doctor_schedule")
public class DoctorScheduleVo {

    /**
     * 出诊主键id
     */
    @TableAnnotation("schedule_id")
    @ApiModelProperty(notes = "出诊主键id")
    private String scheduleId;
    /**
     * 医生id
     */
    @TableAnnotation("doctor_id")
    @ApiModelProperty(notes = "医生id")
    private String doctorId;
    /**
     * 出诊日期
     */
    @TableAnnotation("business_days")
    @ApiModelProperty(notes = "出诊日期")
    private String businessDays;
    /**
     * 出诊开始时段
     */
    @TableAnnotation("start_time_slot")
    @ApiModelProperty(notes = "出诊开始时段")
    private String startTimeSlot;
    /**
     * 出诊结束时段
     */
    @TableAnnotation("end_time_slot")
    @ApiModelProperty(notes = "出诊结束时段")
    private String endTimeSlot;
    /**
     * 可预约总库存
     */
    @TableAnnotation("total_stock")
    @ApiModelProperty(notes = "可预约总库存")
    private Integer totalStock;
    /**
     * 剩余库存
     */
    @TableAnnotation("remaining_stock")
    @ApiModelProperty(notes = "剩余库存")
    private Integer remainingStock;
    /**
     * 开始日期
     */
    @TableAnnotation("start_date")
    @ApiModelProperty(notes = "开始日期")
    private String startDate;
    /**
     * 结束日期
     */
    @TableAnnotation("end_date")
    @ApiModelProperty(notes = "结束日期")
    private String endDate;
    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public DoctorScheduleVo() {
    }

    public String getScheduleId() {
        return scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getDoctorId() {
        return doctorId;
    }

    public void setDoctorId(String doctorId) {
        this.doctorId = doctorId;
    }

    public String getBusinessDays() {
        return businessDays;
    }

    public void setBusinessDays(String businessDays) {
        this.businessDays = businessDays;
    }

    public String getStartTimeSlot() {
        return startTimeSlot;
    }

    public void setStartTimeSlot(String startTimeSlot) {
        this.startTimeSlot = startTimeSlot;
    }

    public String getEndTimeSlot() {
        return endTimeSlot;
    }

    public void setEndTimeSlot(String endTimeSlot) {
        this.endTimeSlot = endTimeSlot;
    }

    public Integer getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Integer totalStock) {
        this.totalStock = totalStock;
    }

    public Integer getRemainingStock() {
        return remainingStock;
    }

    public void setRemainingStock(Integer remainingStock) {
        this.remainingStock = remainingStock;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
