package com.tcm.util.product;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_product_extend")
public class ProductExtendVo {

    /**
     * 产品扩展主键id
     */
    @TableAnnotation("product_extend_id")
    @ApiModelProperty(notes = "产品扩展主键id")
    private String productExtendId;
    /**
     * 关联产品id
     */
    @TableAnnotation("product_id")
    @ApiModelProperty(notes = "关联产品id")
    private String productId;
    /**
     * 标题
     */
    @TableAnnotation("title")
    @ApiModelProperty(notes = "标题")
    private String title;
    /**
     * 描述详情
     */
    @TableAnnotation("description")
    @ApiModelProperty(notes = "描述详情")
    private String description;
    /**
     * 位置
     */
    @TableAnnotation("position")
    @ApiModelProperty(notes = "位置")
    private String position;
    /**
     * 服务类型
     */
    @TableAnnotation("service_type")
    @ApiModelProperty(notes = "服务类型")
    private Integer serviceType;
    /**
     * 服务时长
     */
    @TableAnnotation("service_duration")
    @ApiModelProperty(notes = "服务时长")
    private String serviceDuration;
    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public ProductExtendVo() {
    }

    public String getProductExtendId() {
        return productExtendId;
    }

    public void setProductExtendId(String productExtendId) {
        this.productExtendId = productExtendId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Integer getServiceType() {
        return serviceType;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceDuration() {
        return serviceDuration;
    }

    public void setServiceDuration(String serviceDuration) {
        this.serviceDuration = serviceDuration;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
