package com.tcm.common.dao.impl;

import com.tcm.common.dao.CarouselDao;
import com.tcm.util.common.CarouselVo;
import com.tcm.util.common.req.CarouselLoadPageReqVo;
import com.tcm.util.common.req.CarouselReqVo;
import com.tcm.util.common.res.CarouselResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

@Component
public class CarouselDaoImpl extends BaseDaoImpl implements CarouselDao {

    private final static String SQL_LOAD = "loadCarousel";

    @Override
    protected void init() {
        register(CarouselVo.class);
        table.add(SQL_LOAD, "select p.*,pe.title as title,pe.carousel_info as carouselInfo from tcm_carousel as p " +
                "left join tcm_carousel_extend as pe on p.carousel_id = pe.carousel_id  where 1=1 {WHERE} order by p.sort")
                .add("carousel_id", "and p.carousel_id =?")
                .add("carousel_type", "and p.carousel_type =?")
                .add("carousel_status", "and p.carousel_status =?")
                .add("languageType", "and pe.language_type =?")
        ;
    }

    @Override
    public CarouselResVo loadInfo(CarouselReqVo carouselReqVo) {
        return this.queryFirst(CarouselResVo.class, SQL_LOAD, carouselReqVo);
    }

    @Override
    public PageSizeData<CarouselResVo> loadByPage(CarouselLoadPageReqVo req) {
        return this.queryPage(CarouselResVo.class, req, SQL_LOAD, req);
    }
}
