package com.tcm.common.dao.impl;

import com.tcm.common.dao.FloorAreaDao;
import com.tcm.util.area.FloorAreaVo;
import com.tcm.util.area.req.FloorAreaLoadPageReqVo;
import com.tcm.util.area.req.FloorAreaReqVo;
import com.tcm.util.area.res.FloorAreaResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class FloorAreaDaoImpl extends BaseDaoImpl implements FloorAreaDao {

    private final String SQL_LOAD_BY_SORT = "loadBySort";

    @Override
    protected void init() {
        register(FloorAreaVo.class);
        table.add(SQL_LOAD_BY_SORT, "select p.*,pe.area_name as areaName,pe.area_desc as areaDesc,pe.position as position from tcm_floor_area as p " +
                "left join tcm_floor_area_extend as pe on p.area_id =pe.area_id where 1=1 {WHERE}  order by sort")
                .add("floorId", "and p.floor_id =?")
                .add("areaId", "and p.area_id =?")
                .add("areaName", "and p.area_name =?")
                .add("isFeature", "and p.is_feature =?")
                .add("areaStatus", "and p.area_status =?")
                .add("createTime", "and p.create_time =?")
                .add("languageType", "and pe.language_type =?")
        ;
    }

    @Override
    public List<FloorAreaResVo> loadBySort(FloorAreaReqVo req) {
        return this.query(FloorAreaResVo.class, SQL_LOAD_BY_SORT, req);
    }

    @Override
    public FloorAreaResVo loadInfo(FloorAreaReqVo req) {
        return this.queryFirst(FloorAreaResVo.class, SQL_LOAD_BY_SORT, req);
    }

    @Override
    public PageSizeData<FloorAreaResVo> loadByPage(FloorAreaLoadPageReqVo req) {
        return this.queryPage(FloorAreaResVo.class, req, SQL_LOAD_BY_SORT, req);
    }
}
