package com.tcm.common.service.impl;

import com.tcm.common.dao.CenterDisplayDao;
import com.tcm.common.dao.ImageDao;
import com.tcm.common.service.CenterDisplayService;
import com.tcm.common.service.ImageService;
import com.tcm.util.area.CenterDisplayVo;
import com.tcm.util.area.req.CenterDisplayReqVo;
import com.tcm.util.area.res.CenterDisplayResVo;
import com.tcm.util.common.req.ImageReqVo;
import com.yanzuoguang.util.base.ObjectHelper;
import com.yanzuoguang.util.helper.DateHelper;
import com.yanzuoguang.util.helper.StringHelper;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CenterDisplayServiceImpl implements CenterDisplayService {

    private final CenterDisplayDao centerDisplayDao;
    private final ImageService imageService;

    public CenterDisplayServiceImpl(CenterDisplayDao centerDisplayDao,
                                     ImageService imageService) {
        this.centerDisplayDao = centerDisplayDao;
        this.imageService = imageService;
    }

    @Override
    public String save(CenterDisplayReqVo req) {
        if (StringHelper.isEmpty(req.getDisplayId())) {
            CenterDisplayVo centerDisplay = new CenterDisplayVo();
            String displayId = StringHelper.getNewID();
            centerDisplay.setDisplayId(displayId);
            ObjectHelper.writeWithFrom(centerDisplay, req);
            centerDisplay.setCreateTime(DateHelper.getNow());
            centerDisplayDao.save(centerDisplay);
            return displayId;
        } else {
            CenterDisplayVo centerDisplay = new CenterDisplayVo();
            centerDisplay.setDisplayId(req.getDisplayId());
            CenterDisplayVo load = centerDisplayDao.load(centerDisplay, CenterDisplayResVo.class);
            ObjectHelper.writeWithFrom(load, req);
            load.setUpdateTime(DateHelper.getNow());
            centerDisplayDao.update(load);
            return req.getDisplayId();

        }
    }

    @Override
    public CenterDisplayResVo load(CenterDisplayReqVo req) {
        CenterDisplayVo centerDisplay = new CenterDisplayVo();
        centerDisplay.setDisplayId(req.getDisplayId());
        return centerDisplayDao.load(centerDisplay, CenterDisplayResVo.class);

    }

    @Override
    public List<CenterDisplayResVo> loadList(CenterDisplayReqVo req) {
        List<CenterDisplayResVo> list = centerDisplayDao.loadByList(req);
        return list;
    }

    @Override
    public String remove(CenterDisplayReqVo req) {
        CenterDisplayVo centerDisplay = new CenterDisplayVo();
        centerDisplay.setDisplayId(req.getDisplayId());
        centerDisplayDao.remove(centerDisplay);

        ImageReqVo imageReqVo = new ImageReqVo();
        imageReqVo.setRelationId(req.getDisplayId());
        imageService.remove(imageReqVo);
        return req.getDisplayId();
    }

}
