package com.tcm.util.area;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.models.auth.In;

@TableAnnotation("tcm_floor_area")
public class FloorAreaVo {

    /**
     * 区域主键id
     */
    @TableAnnotation("area_id")
    @ApiModelProperty(notes = "区域主键id")
    private String areaId;
    /**
     * 楼层主键id
     */
    @TableAnnotation("floor_id")
    @ApiModelProperty(notes = "楼层主键id")
    private String floorId;

    /**
     * 是否特殊区0是1否
     */
    @TableAnnotation("is_feature")
    @ApiModelProperty(notes = "是否特殊区0是1否")
    private Integer isFeature;


    /**
     * 区域图标
     */
    @TableAnnotation("area_icon")
    @ApiModelProperty(notes = "区域图标")
    private String areaIcon;
    /**
     * 排序
     */
    @TableAnnotation("sort")
    @ApiModelProperty(notes = "排序")
    private Integer sort;

    /**
     * 区域状态0启用1禁用
     */
    @TableAnnotation("area_status")
    @ApiModelProperty(notes = "区域状态0启用1禁用")
    private Integer areaStatus;

    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public FloorAreaVo() {
    }

    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }

    public String getFloorId() {
        return floorId;
    }

    public void setFloorId(String floorId) {
        this.floorId = floorId;
    }

    public Integer getIsFeature() {
        return isFeature;
    }

    public void setIsFeature(Integer isFeature) {
        this.isFeature = isFeature;
    }

    public String getAreaIcon() {
        return areaIcon;
    }

    public void setAreaIcon(String areaIcon) {
        this.areaIcon = areaIcon;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getAreaStatus() {
        return areaStatus;
    }

    public void setAreaStatus(Integer areaStatus) {
        this.areaStatus = areaStatus;
    }
}
