package com.tcm.util.product;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_product_stock")
public class ProductStockVo {
    /**
     * 库存主键id
     */
    @TableAnnotation("stock_id")
    @ApiModelProperty(notes = "库存主键id")
    private String stockId;
    /**
     * 产品id
     */
    @TableAnnotation("product_id")
    @ApiModelProperty(notes = "产品id")
    private String productId;
    /**
     * 库存类型
     */
    @TableAnnotation("stock_type")
    @ApiModelProperty(notes = "库存类型")
    private Integer stockType;
    /**
     * 总量
     */
    @TableAnnotation("total")
    @ApiModelProperty(notes = "总量")
    private Integer total;
    /**
     * 剩余量
     */
    @TableAnnotation("surplus")
    @ApiModelProperty(notes = "剩余量")
    private Integer surplus;
    /**
     * 库存状态0上架1下架
     */
    @TableAnnotation("stock_status")
    @ApiModelProperty(notes = "库存状态0上架1下架")
    private Integer stockStatus;
    /**
     * 开始时间
     */
    @TableAnnotation("start_date")
    @ApiModelProperty(notes = "开始时间")
    private String startDate;
    /**
     * 结束时间
     */
    @TableAnnotation("end_date")
    @ApiModelProperty(notes = "结束时间")
    private String endDate;
    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public ProductStockVo() {
    }

    public String getStockId() {
        return stockId;
    }

    public void setStockId(String stockId) {
        this.stockId = stockId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Integer getStockType() {
        return stockType;
    }

    public void setStockType(Integer stockType) {
        this.stockType = stockType;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getSurplus() {
        return surplus;
    }

    public void setSurplus(Integer surplus) {
        this.surplus = surplus;
    }

    public Integer getStockStatus() {
        return stockStatus;
    }

    public void setStockStatus(Integer stockStatus) {
        this.stockStatus = stockStatus;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
