package com.tcm.util.product;

import com.yanzuoguang.dao.TableAnnotation;
import io.swagger.annotations.ApiModelProperty;

@TableAnnotation("tcm_product")
public class ProductVo {


    /**
     * 产品主键id
     */
    @TableAnnotation("product_id")
    @ApiModelProperty(notes = "产品主键id")
    private String productId;
    /**
     * 产品名称
     */
    @TableAnnotation("product_name")
    @ApiModelProperty(notes = "产品名称")
    private String productName;
    /**
     * 类别id
     */
    @TableAnnotation("category_id")
    @ApiModelProperty(notes = "类别id")
    private String categoryId;
    /**
     * 产品类型1 - 大健康产品，2 - 预约产品
     */
    @TableAnnotation("category_type")
    @ApiModelProperty(notes = "产品类型1 - 大健康产品，2 - 预约产品")
    private Integer categoryType;

    /**
     * 产品分类0茶饮类1理疗类2器械类3针灸4推拿5拔罐6熏蒸7养生
     */
    @TableAnnotation("product_type")
    @ApiModelProperty(notes = "产品分类0茶饮类1理疗类2器械类3针灸4推拿5拔罐6熏蒸7养生")
    private Integer productType;
    /**
     * 是否推荐0推荐1不推荐
     */
    @TableAnnotation("is_recommend")
    @ApiModelProperty(notes = "产品类型1 - 大健康产品，2 - 预约产品")
    private Integer isRecommend;


    /**
     * 可约人数 / 天（仅预约产品）
     */
    @TableAnnotation("max_people")
    @ApiModelProperty(notes = "可约人数 / 天（仅预约产品）")
    private Integer maxPeople;
    /**
     * 已预约人数
     */
    @TableAnnotation("booked_people")
    @ApiModelProperty(notes = "已预约人数")
    private Integer bookedPeople;
    /**
     * 售价
     */
    @TableAnnotation("price")
    @ApiModelProperty(notes = "售价")
    private Double price;
    /**
     * 门市价
     */
    @TableAnnotation("market_price")
    @ApiModelProperty(notes = "门市价")
    private Double marketPrice;
    /**
     * 结算价
     */
    @TableAnnotation("settlement_price")
    @ApiModelProperty(notes = "结算价")
    private Double settlementPrice;
    /**
     * 状态
     */
    @TableAnnotation("status")
    @ApiModelProperty(notes = "状态")
    private Integer status;
    /**
     * 排序
     */
    @TableAnnotation("sort")
    @ApiModelProperty(notes = "排序")
    private Integer sort;
    /**
     * 创建时间
     */
    @TableAnnotation("create_time")
    @ApiModelProperty(notes = "创建时间")
    private String createTime;
    /**
     * 更新时间
     */
    @TableAnnotation("update_time")
    @ApiModelProperty(notes = "更新时间")
    private String updateTime;

    public ProductVo() {
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Integer getProductType() {
        return productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public Integer getMaxPeople() {
        return maxPeople;
    }

    public void setMaxPeople(Integer maxPeople) {
        this.maxPeople = maxPeople;
    }

    public Integer getBookedPeople() {
        return bookedPeople;
    }

    public void setBookedPeople(Integer bookedPeople) {
        this.bookedPeople = bookedPeople;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Double getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Double marketPrice) {
        this.marketPrice = marketPrice;
    }

    public Double getSettlementPrice() {
        return settlementPrice;
    }

    public void setSettlementPrice(Double settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(Integer categoryType) {
        this.categoryType = categoryType;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }
}
