package com.pangding.web.authority.dao.impl;

import com.pangding.web.authority.dao.CompanyMsgDao;
import com.pangding.web.authority.vo.resvo.GetCompanyMsgResVo;
import com.pangding.web.vo.system.pd.CompanyMsgVo;
import com.pangding.web.vo.system.req.CompanyMsgReqVo;
import com.pangding.web.vo.system.res.CompanyMsgResVo;
import com.yanzuoguang.dao.impl.BaseDaoImpl;
import com.yanzuoguang.util.vo.PageSizeData;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class CompanyMsgDaoImpl extends BaseDaoImpl implements CompanyMsgDao {

    private static final String QUERY_LIST_PAGE = "QUERY_LIST_PAGE";

    private static final String QUERY_LIST = "QUERY_LIST";

    @Override
    protected void init() {

        register(CompanyMsgVo.class);

        table.add(QUERY_LIST_PAGE, "select m.*,cm.company_id,cm.type,cm.merchant_id " +
                "from pd_company_msg cm left join pd_msg m on cm.msg_id = m.id where 1=1 ")
                .add("companyId", "and cm.company_id = ? ")
                .add("", " AND cm.merchantId = ? ")
                .add("type", "and cm.type = ? ");

    }

    @Override
    public List<GetCompanyMsgResVo> findCompanyMsgList(CompanyMsgReqVo req) {
        return this.query(GetCompanyMsgResVo.class, QUERY_LIST_PAGE, req);
    }

    @Override
    public PageSizeData<CompanyMsgResVo> findPageCompanyMsgList(CompanyMsgReqVo req) {
        return this.queryPage(CompanyMsgResVo.class, req, QUERY_LIST_PAGE, req);
    }

}
